function mddefs(command)
global MDDatObjs;
if(nargin < 1)
	ArrowDefs = MDDatObjs.Defaults.ArrowDefs;
	CirclePoints = MDDatObjs.Defaults.CirclePoints;
	SelectionColor = MDDatObjs.Defaults.SelectionColor;
	FontName = MDDatObjs.Defaults.FontName;
	FontSize = MDDatObjs.Defaults.FontSize;
	FontWeight = MDDatObjs.Defaults.FontWeight;
	FontAngle = MDDatObjs.Defaults.FontAngle;
	LineStyle = MDDatObjs.Defaults.LineStyle;
	Marker = MDDatObjs.Defaults.Marker;
	MarkerPenColor = MDDatObjs.Defaults.MarkerPenColor;
	MarkerFillColor = MDDatObjs.Defaults.MarkerFillColor;
	LineWidth = MDDatObjs.Defaults.LineWidth;
	PenColor = MDDatObjs.Defaults.PenColor;
	FillColor = MDDatObjs.Defaults.FillColor;
	TextAlignment = MDDatObjs.Defaults.TextAlignment;
	ArrowLength = ArrowDefs(1);
	ArrowWidth = ArrowDefs(2);
	ArrowBase = ArrowDefs(3);
	ArrowTip = ArrowDefs(4);
	ArrowStyle = MDDatObjs.Defaults.ArrowStyle;
	SaveString = MDDatObjs.Defaults.SaveString;
	PalettePos = MDDatObjs.Defaults.PalettePos;

	BackgroundColor = .8*ones(1,3);
	ForegroundColor = 'k';
	Widgetbground = .7*ones(1,3);
	Widgetfground = [0 0 0];
	figpos = [100 350 340 180];
	fig = gcf;
	titlefig = figure('Units','Points',...
	                  'Color',BackgroundColor,...
	                  'Position',figpos,...
					  'Name','Preferences',...
					  'Resize','off',...
					  'NumberTitle','off');
	set(titlefig,'DefaultUIControlFontSize',9)
	axis off;
	set(gca,'position',[0 0 1 1]);
	axis(axis);
	top = figpos(4);
	right = figpos(3);
	leftmargin = 10;
	rightmargin = 10;
	topmargin = 10;
	vspace = 10;
	hspace = 5;
	popupwidth = 30;
	edsize = objsize('edit',5);

	txtsize = textlen(['Set defaults for:          ';   
					   'Lines & Patches            ';  
					   'Fill Color                 '; 
					   'Magenta                    ';
					   'Line Width                 ';
					   '00.0                       '; 
					   'Number of points in circles'; 
					   'Cancel                     '; 
					   'Length                     '; 
					   'Base Angle                 '; 
					   'Remove from list           '; 
					   'Weight                     ';
					   'Selection Color            ';
					   '[0.5   0.5   0.5]          ';
						'Marker Fill                ']);

	position = [leftmargin top-topmargin-edsize(2) txtsize(1) edsize(2)];
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Set defaults for:',...
						'Units','points',...
						'UserData','Always_On',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(2)+popupwidth;
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Popupmenu',...
						'String','General|Lines & Patches|Text|Arrows',...
						'Value',1,...
						'Units','points',...
						'Tag','PAGE',...
						'Callback','mddefs(''Defaults Page'')',...
						'UserData','Always_On',...
						'Position',position);
						
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lines & Patches Defaults %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
						
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(3);
	row1 = position(2);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Pen Color',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(4)+popupwidth;
	col2 = position(1);
	if(all(PenColor == [1 1 0]))
		value = 1;
	elseif(all(PenColor == [1 0 1]))
		value = 2;
	elseif(all(PenColor == [0 1 1]))
		value = 3;
	elseif(all(PenColor == [1 0 0]))
		value = 4;
	elseif(all(PenColor == [0 1 0]))
		value = 5;
	elseif(all(PenColor == [0 0 1]))
		value = 6;
	elseif(all(PenColor == [1 1 1]))
		value = 7;
	elseif(all(PenColor == [0 0 0]))
		value = 8;
	else 
		value = 9;
	end
	if(norm(PenColor) >= .5)
		fground = [0 0 0];
	else
		fground = [1 1 1];
	end	
	storage = get(gcf,'UserData');
	storage.PenColorValue = value;
	set(gcf,'UserData',storage);
	g = uicontrol(titlefig,'BackgroundColor',PenColor,...
						'ForegroundColor',fground,...
						'Style','Popupmenu',...
						'String','Yellow|Magenta|Cyan|Red|Green|Blue|White|Black|Other',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','PENCOLOR',...
						'Callback','mddefs(''PENCOLOR'')',...
						'Position',position);
	position(1) = position(1)+position(3)+2*hspace;
	position(3) = txtsize(15);
	col3 = position(1);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Marker Pen',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(4)+popupwidth;
	col4 = position(1);
	if(all(MarkerPenColor == [1 1 0]))
		value = 1;
	elseif(all(MarkerPenColor == [1 0 1]))
		value = 2;
	elseif(all(MarkerPenColor == [0 1 1]))
		value = 3;
	elseif(all(MarkerPenColor == [1 0 0]))
		value = 4;
	elseif(all(MarkerPenColor == [0 1 0]))
		value = 5;
	elseif(all(MarkerPenColor == [0 0 1]))
		value = 6;
	elseif(all(MarkerPenColor == [1 1 1]))
		value = 7;
	elseif(all(MarkerPenColor == [0 0 0]))
		value = 8;
	else 
		value = 9;
	end
	if(norm(MarkerPenColor) >= .5)
		fground = [0 0 0];
	else
		fground = [1 1 1];
	end	
	storage = get(gcf,'UserData');
	storage.MarkerPenColorValue = value;
	set(gcf,'UserData',storage);
	g = uicontrol(titlefig,'BackgroundColor',MarkerPenColor,...
						'ForegroundColor',fground,...
						'Style','Popupmenu',...
						'String','Yellow|Magenta|Cyan|Red|Green|Blue|White|Black|Other',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','MARKERPEN',...
						'Callback','mddefs(''MARKERPEN'')',...
						'Position',position);
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(3);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Fill Color',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);

	if(isstr(FillColor))
		value = 9;
	elseif(all(FillColor == [1 1 0]))
		value = 1;
	elseif(all(FillColor == [1 0 1]))
		value = 2;
	elseif(all(FillColor == [0 1 1]))
		value = 3;
	elseif(all(FillColor == [1 0 0]))
		value = 4;
	elseif(all(FillColor == [0 1 0]))
		value = 5;
	elseif(all(FillColor == [0 0 1]))
		value = 6;
	elseif(all(FillColor == [1 1 1]))
		value = 7;
	elseif(all(FillColor == [0 0 0]))
		value = 8;
	else 
		value = 10;
	end
	if(value == 9)
		bground = Widgetbground;
	else
		bground = FillColor;
	end
	if(norm(bground) >= .5)
		fground = [0 0 0];
	else
		fground = [1 1 1];
	end
	storage = get(gcf,'UserData');
	storage.FillColorValue = value;
	set(gcf,'UserData',storage);
	position(1) = col2;
	position(3) = txtsize(4)+popupwidth;
	uicontrol(titlefig,'BackgroundColor',bground,...
						'ForegroundColor',fground,...
						'Style','Popupmenu',...
						'String','Yellow|Magenta|Cyan|Red|Green|Blue|White|Black|None|Other',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','FILLCOLOR',...
						'Callback','mddefs(''FILLCOLOR'')',...
						'Position',position);
	
	position(1) = col3;
	position(3) = txtsize(15);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Marker Fill',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(4)+popupwidth;
	if(all(MarkerFillColor == [1 1 0]))
		value = 1;
	elseif(all(MarkerFillColor == [1 0 1]))
		value = 2;
	elseif(all(MarkerFillColor == [0 1 1]))
		value = 3;
	elseif(all(MarkerFillColor == [1 0 0]))
		value = 4;
	elseif(all(MarkerFillColor == [0 1 0]))
		value = 5;
	elseif(all(MarkerFillColor == [0 0 1]))
		value = 6;
	elseif(all(MarkerFillColor == [1 1 1]))
		value = 7;
	elseif(all(MarkerFillColor == [0 0 0]))
		value = 8;
	else 
		value = 9;
	end
	if(norm(MarkerPenColor) >= .5)
		fground = [0 0 0];
	else
		fground = [1 1 1];
	end	
	storage = get(gcf,'UserData');
	storage.MarkerFillColorValue = value;
	set(gcf,'UserData',storage);
	g = uicontrol(titlefig,'BackgroundColor',MarkerPenColor,...
						'ForegroundColor',fground,...
						'Style','Popupmenu',...
						'String','Yellow|Magenta|Cyan|Red|Green|Blue|White|Black|Other',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','MARKERFILL',...
						'Callback','mddefs(''MARKERFILL'')',...
						'Position',position);
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(5);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Line Width',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Edit',...
						'String',num2str(LineWidth),...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','LINEWIDTH',...
						'Position',position);
	position(1) = position(1)+position(3)+2*hspace;
	position(3) = txtsize(5);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Line Style',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Edit',...
						'String',LineStyle,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','LINESTYLE',...
						'Position',position);
	position(1) = position(1)+position(3)+2*hspace;
	position(3) = txtsize(8);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Marker',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(5);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Edit',...
						'String',Marker,...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','MARKER',...
						'Callback','mddefs markercheck',...
						'Position',position);
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(7);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'Style','text',...
						'String','Number of points in circles',...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Edit',...
						'String',num2str(CirclePoints),...
						'Units','points',...
						'Visible','off',...
						'UserData','LineDefs',...
						'Tag','CIRCLEPOINTS',...
						'Position',position);

%%%%%%%%%%%%%%%%%
% OK and Cancel %
%%%%%%%%%%%%%%%%%

	position(1) = figpos(3)-rightmargin-txtsize(9);
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(8);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Pushbutton',...
						'String','OK',...
						'Units','points',...
						'UserData','Always_On',...
						'Callback','mddefs(''OK'');delete(gcf)',...
						'Position',position);

	position(1) = position(1)-hspace-txtsize(8);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'Style','Pushbutton',...
						'String','Cancel',...
						'Units','points',...
						'UserData','Always_On',...
						'Callback','mddefs(''Cancel'')',...
						'Position',position);

%%%%%%%%%%%%%%%%%%
% Arrow Defaults %
%%%%%%%%%%%%%%%%%%

	position(1) = leftmargin;
	position(2) = row1;
	position(3) = txtsize(10);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Tip Angle',...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Position',position);
	position(1) = position(1)+position(3);
	position(3) = txtsize(6);
	col2 = position(1);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',num2str(ArrowTip),...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Tag','ARROWTIP',...
						'Position',position);
	
	position(1) = col3;
	position(3) = txtsize(9);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Width',...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(6);
	col4 = position(1);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',num2str(ArrowWidth),...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Tag','ARROWWIDTH',...
						'Position',position);
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(10);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Base Angle',...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Position',position);
	position(1) = col2;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',num2str(ArrowBase),...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Tag','ARROWBASE',...
						'Position',position);
	
	position(1) = col3;
	position(3) = txtsize(9);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Length',...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Position',position);
	position(1) = col4;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',num2str(ArrowLength),...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Tag','ARROWLENGTH',...
						'Position',position);

	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(3);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','End Style',...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Position',position);
	position(1) = col2;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',ArrowStyle,...
						'Units','points',...
						'Visible','off',...
						'UserData','ArrowDefs',...
						'Tag','ARROWSTYLE',...
						'Position',position);
	
%%%%%%%%%%%%%%%%%%
% Text Defaults %
%%%%%%%%%%%%%%%%%%

	position(1) = leftmargin;
	position(2) = row1;
	position(3) = txtsize(12);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Angle',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Position',position);
	position(1) = position(1)+position(3);
	position(3) = txtsize(4)+popupwidth;
	col2 = position(1);
	if(strcmp(lower(FontAngle),'normal'))
		value = 1;
	elseif(strcmp(lower(FontAngle),'italic'))
		value = 2;
	elseif(strcmp(lower(FontAngle),'oblique'))
		value = 3;
	end
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Popupmenu',...
						'String','Normal|Italic|Oblique',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Tag','FONTANGLE',...
						'Position',position);
	
	position(1) = col3;
	position(3) = txtsize(9);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Font',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Position',position);
	position(1) = position(1)+position(3)+hspace;
	position(3) = txtsize(2)+popupwidth;
	col4 = position(1);
	fontmenu = uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Popupmenu',...
						'String','',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Tag','FONTNAME',...
						'Position',position);
	kids=get(findobj(fig,'label','Font'),'Children');
	str = [];
	for(i=1:length(kids)-1)
		str = [str get(kids(i),'label') '|'];
		if(strcmp(get(kids(i),'label'),MDDatObjs.Defaults.FontName))
			val = i;
		end
	end
	str = [str get(kids(i+1),'label')];
	set(fontmenu,'string',str);
	set(fontmenu,'value',val);
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(10);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Weight',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Position',position);
	if(strcmp(lower(FontWeight),'light'))
		value = 1;
	elseif(strcmp(lower(FontWeight),'normal'))
		value = 2;
	elseif(strcmp(lower(FontWeight),'demi'))
		value = 3;
	elseif(strcmp(lower(FontWeight),'bold'))
		value = 4;
	end
	position(1) = col2;
	position(3) = txtsize(4)+popupwidth;
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','PopupMenu',...
						'String','Light|Normal|Demi|Bold',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Tag','FONTWEIGHT',...
						'Position',position);
	position(1) = col3;
	position(3) = txtsize(10);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Alignment',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Position',position);
	position(1) = col4;
	position(3) = txtsize(2)+popupwidth;
	if(strcmp(lower(TextAlignment),'left'))
		value = 1;
	elseif(strcmp(lower(TextAlignment),'center'))
		value = 2;
	elseif(strcmp(lower(TextAlignment),'right'))
		value = 3;
	end
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Popupmenu',...
						'String','Left|Center|Right',...
						'Value',value,...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Tag','TEXTALIGNMENT',...
						'Position',position);
	
	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	position(3) = txtsize(3);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Size',...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Position',position);
	position(1) = col2;
	position(3) = txtsize(6);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',num2str(FontSize),...
						'Units','points',...
						'Visible','off',...
						'UserData','TextDefs',...
						'Tag','FONTSIZE',...
						'Position',position);
	
%%%%%%%%%%%%%%%%%%%%
% General Defaults %
%%%%%%%%%%%%%%%%%%%%
						
	position(1) = leftmargin;
	position(2) = row1;
	position(3) = txtsize(13);
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Selection Color',...
						'Units','points',...
						'Visible','on',...
						'UserData','GenDefs',...
						'Position',position);

	position(1) = position(1)+position(3);
	position(3) = txtsize(14);
	col2 = position(1);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Edit',...
						'String',['[' num2str(SelectionColor(1)) ' ' num2str(SelectionColor(2)) ' ' num2str(SelectionColor(3)) ']'],...
						'Units','points',...
						'Visible','on',...
						'UserData','GenDefs',...
						'Callback','mddefs(''SELECTIONCOLOR'')',...
						'Tag','SELECTIONCOLOR',...
						'Position',position);

	position(1) = position(1)+position(3)+2*hspace;
	position(3) = txtsize(13);
	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Center',...
						'Style','Pushbutton',...
						'String','Save Settings',...
						'Units','points',...
						'Visible','on',...
						'UserData','GenDefs',...
						'Callback','mddefs(''Save Settings'')',...
						'Position',position);

	position(1) = leftmargin;
	position(2) = position(2)-edsize(2)-vspace;
	uicontrol(titlefig,'BackgroundColor',BackgroundColor,...
						'ForegroundColor',ForegroundColor,...
						'HorizontalAlignment','Left',...
						'Style','text',...
						'String','Print string',...
						'Units','points',...
						'Visible','on',...
						'UserData','GenDefs',...
						'Position',position);
	
	position(1) = col2;
	position(3) = txtsize(14);

	uicontrol(titlefig,'BackgroundColor',Widgetbground,...
						'ForegroundColor',Widgetfground,...
						'HorizontalAlignment','Left',...
						'Style','Edit',...
						'String',SaveString,...
						'Units','points',...
						'Visible','on',...
						'UserData','GenDefs',...
						'Tag','SAVESTRING',...
						'Position',position);
	set(titlefig,'Handlevisibility','Callback');
elseif(strcmp(command,'markercheck'))
	
elseif(strcmp(command,'Save Settings'))
	mddefs('OK');
	Defaults = MDDatObjs.Defaults;

	PalettePos = getset(findobj('type','figure','name','Draw Tools'),'Position','Units','Normalized');
	Defaults.PalettePos = [PalettePos(1) PalettePos(2)+PalettePos(4)]; % Upper Left Corner

	[filename,filepath] = uiputfile('mdprefs.mat','Save MatDraw Preferences As:');
	if(filename)
			save([filepath filename],'Defaults');
	end
elseif(strcmp(command,'SELECTIONCOLOR'))
	if(strcmp(get(findobj(gcf,'Tag','SELECTIONCOLOR'),'String'),'Other'))
		scolor = choosecolor;
		set(findobj(gcf,'Tag','SELECTIONCOLOR'),'String',[num2str(scolor(1)) ' '...
		num2str(scolor(2)) ' ' num2str(scolor(3))]);
	else
		scolor = str2num(get(findobj(gcf,'Tag','SELECTIONCOLOR'),'String'));
		if(norm(scolor)>=.5)
			set(findobj(gcf,'Tag','SELECTIONCOLOR'),'ForegroundColor',[0 0 0]);
		else
			set(findobj(gcf,'Tag','SELECTIONCOLOR'),'ForegroundColor',[1 1 1]);
		end
		set(findobj(gcf,'Tag','SELECTIONCOLOR'),'BackgroundColor',scolor);
	end
elseif(strcmp(command,'PENCOLOR'))
	obj = findobj(gcf,'Tag','PENCOLOR');
	val = get(obj,'Value');
	str = get(obj,'String');
	str = deblank(str(val,:));
	storage = get(gcf,'UserData');
	oldcolor = get(obj,'BackgroundColor');
	if(strcmp(str,'Other'))
		scolor = choosecolor;
		if (scolor == 0)
			scolor = oldcolor;
			set(obj,'Value',storage.PenColorValue);
		end
	elseif(strcmp(str,'Black'))
		scolor = [0 0 0];
	else
		scolor = str(1);
	end
	set(obj,'BackgroundColor',scolor);
	if(norm(get(obj,'BackgroundColor'))>=.5)
		set(obj,'ForegroundColor',[0 0 0]);
	else
		set(obj,'ForegroundColor',[1 1 1]);
	end
	storage.PenColorValue = get(obj,'Value');
	set(gcf,'UserData',storage);
elseif(strcmp(command,'MARKERPEN'))
	obj = findobj(gcf,'Tag','MARKERPEN');
	val = get(obj,'Value');
	str = get(obj,'String');
	str = deblank(str(val,:));
	storage = get(gcf,'UserData');
	oldcolor = get(obj,'BackgroundColor');
	if(strcmp(str,'Other'))
		scolor = choosecolor;
		if (scolor == 0)
			scolor = oldcolor;
			set(obj,'Value',storage.MarkerPenColorValue);
		end
	elseif(strcmp(str,'Black'))
		scolor = [0 0 0];
	else
		scolor = str(1);
	end
	set(obj,'BackgroundColor',scolor);
	if(norm(get(obj,'BackgroundColor'))>=.5)
		set(obj,'ForegroundColor',[0 0 0]);
	else
		set(obj,'ForegroundColor',[1 1 1]);
	end
	storage.MarkerPenColorValue = get(obj,'Value');
	set(gcf,'UserData',storage);
elseif(strcmp(command,'FILLCOLOR'))
	obj = findobj(gcf,'Tag','FILLCOLOR');
	val = get(obj,'Value');
	str = get(obj,'String');
	str = deblank(str(val,:));
	storage = get(gcf,'UserData');
	oldcolor = get(obj,'BackgroundColor');
	if(~strcmp(str,'None'))
		if(strcmp(str,'Other'))
			scolor = choosecolor;
			if (scolor == 0)
				scolor = oldcolor;
				set(obj,'Value',storage.FillColorValue);
			end
		elseif(strcmp(str,'Black'))
			scolor = [0 0 0];
		else
			scolor = str(1);
		end
		set(obj,'BackgroundColor',scolor);
		if(norm(get(obj,'BackgroundColor'))>=.5)
			set(obj,'ForegroundColor',[0 0 0]);
		else
			set(obj,'ForegroundColor',[1 1 1]);
		end
	else
		Widgetbground = .7*ones(1,3);
		Widgetfground = [0 0 0];
		set(obj,'BackgroundColor',Widgetbground,'ForegroundColor',Widgetfground);
	end	
	storage.FillColorValue = get(obj,'Value');
	set(gcf,'UserData',storage);
elseif(strcmp(command,'MARKERFILL'))
	obj = findobj(gcf,'Tag','MARKERFILL');
	val = get(obj,'Value');
	str = get(obj,'String');
	str = deblank(str(val,:));
	storage = get(gcf,'UserData');
	oldcolor = get(obj,'BackgroundColor');
	if(~strcmp(str,'None'))
		if(strcmp(str,'Other'))
			scolor = choosecolor;
			if (scolor == 0)
				scolor = oldcolor;
				set(obj,'Value',storage.MarkerFillColorValue);
			end
		elseif(strcmp(str,'Black'))
			scolor = [0 0 0];
		else
			scolor = str(1);
		end
		set(obj,'BackgroundColor',scolor);
		if(norm(get(obj,'BackgroundColor'))>=.5)
			set(obj,'ForegroundColor',[0 0 0]);
		else
			set(obj,'ForegroundColor',[1 1 1]);
		end
	else
		Widgetbground = .7*ones(1,3);
		Widgetfground = [0 0 0];
		set(obj,'BackgroundColor',Widgetbground,'ForegroundColor',Widgetfground);
	end	
	storage.MarkerFillColorValue = get(obj,'Value');
	set(gcf,'UserData',storage);
elseif(strcmp(command,'Defaults Page'))
	value = get(findobj(gcf,'Tag','PAGE'),'Value');
	alluis = findobj(gcf,'Type','uicontrol');
	always_on_uis = findobj(gcf,'UserData','Always_On')';
	grp = alluis(find(all(alluis(:,ones(1,length(always_on_uis)))'...
				          ~=always_on_uis(ones(length(alluis),1),:)')));
	set(grp,'Visible','off');
	if(value == 1)  % General Preferences
		set(findobj(gcf,'UserData','GenDefs'),'Visible','on');
	elseif(value == 2)  % Lines & Patches
		set(findobj(gcf,'UserData','LineDefs'),'Visible','on');
	elseif(value == 3)  % Text
		set(findobj(gcf,'UserData','TextDefs'),'Visible','on');
	elseif(value == 4)  % Arrows
		set(findobj(gcf,'UserData','ArrowDefs'),'Visible','on');
	end
elseif(strcmp(command,'OK'))
	MDDatObjs.Defaults.CirclePoints = str2num(get(findobj(gcf,'Tag','CIRCLEPOINTS'),'String'));
	MDDatObjs.Defaults.SelectionColor = str2num(get(findobj(gcf,'Tag','SELECTIONCOLOR'),'String'));
	MDDatObjs.Defaults.FontSize = str2num(get(findobj(gcf,'Tag','FONTSIZE'),'String'));
	string = get(findobj(gcf,'Tag','FONTWEIGHT'),'String');
	value = get(findobj(gcf,'Tag','FONTWEIGHT'),'Value');
	MDDatObjs.Defaults.FontWeight = deblank(string(value,:));
	string = get(findobj(gcf,'Tag','FONTANGLE'),'String');
	value = get(findobj(gcf,'Tag','FONTANGLE'),'Value');
	MDDatObjs.Defaults.FontAngle = deblank(string(value,:));
	string = get(findobj(gcf,'Tag','TEXTALIGNMENT'),'String');
	value = get(findobj(gcf,'Tag','TEXTALIGNMENT'),'Value');
	MDDatObjs.Defaults.TextAlignment = deblank(string(value,:));
	MDDatObjs.Defaults.LineStyle = get(findobj(gcf,'Tag','LINESTYLE'),'String');
	MDDatObjs.Defaults.Marker = get(findobj(gcf,'Tag','MARKER'),'String');
	MDDatObjs.Defaults.LineWidth = str2num(get(findobj(gcf,'Tag','LINEWIDTH'),'String'));
	MDDatObjs.Defaults.PenColor = get(findobj(gcf,'Tag','PENCOLOR'),'Backgroundcolor');
	if(get(findobj(gcf,'Tag','FILLCOLOR'),'Value')==9)
		MDDatObjs.Defaults.FillColor = 'None';
	else
		MDDatObjs.Defaults.FillColor = get(findobj(gcf,'Tag','FILLCOLOR'),'Backgroundcolor');
	end
	oldArrowDefs = MDDatObjs.Defaults.ArrowDefs;
	ArrowDefs = [str2num(get(findobj(gcf,'Tag','ARROWLENGTH'),'string')) ...
				 str2num(get(findobj(gcf,'Tag','ARROWWIDTH'),'string')) ...
				 str2num(get(findobj(gcf,'Tag','ARROWBASE'),'string')) ...
				 str2num(get(findobj(gcf,'Tag','ARROWTIP'),'string')) oldArrowDefs(5:7)]; 
	MDDatObjs.Defaults.Arrow = ArrowDefs;
	MDDatObjs.Defaults.ArrowStyle = get(findobj(gcf,'Tag','ARROWSTYLE'),'String');
	MDDatObjs.Defaults.SaveString = get(findobj(gcf,'Tag','SAVESTRING'),'String');
	str = get(findobj(gcf,'Tag','FONTNAME'),'string');
	val = get(findobj(gcf,'Tag','FONTNAME'),'value');
	MDDatObjs.Defaults.FontName = deblank(str(val,:));
elseif(strcmp(command,'Cancel'))
	delete(gcf);
end
function ext = objsize(ObjType,NumChars,NumLines)
if(nargin < 3)
	NumLines = 1;
end
ext = zeros(1,2);
if(strcmp(computer,'MAC2') | strcmp(computer,'SUN4'))
	if(strcmp(ObjType,'uitext'))
		ext(1) = 10*NumChars+7;
		ext(2) = 13*NumLines - 1;
	elseif(strcmp(ObjType,'edit'))
		ext(1) = 10*NumChars+1;
		ext(2) = 14*NumLines + 4;
	elseif(strcmp(ObjType,'pushbutton'))
		ext(1) = 10*NumChars+6;
		ext(2) = 18;
	elseif(strcmp(ObjType,'popupmenu'))
		ext(1) = 10*NumChars+36;
		ext(2) = 18;
	elseif(strcmp(ObjType,'checkbox') | strcmp(ObjType,'radio'))
		ext(1) = 10*NumChars+17;
		ext(2) = 12;
	end
else
	if(strcmp(ObjType,'uitext'))
		ext(1) = 5*NumChars+3;
		ext(2) = 12*NumLines+2;
	elseif(strcmp(ObjType,'edit'))
		ext(1) = 5*NumChars+4;
		ext(2) = 12*NumLines + 2;
	elseif(strcmp(ObjType,'pushbutton'))
		ext(1) = 6*NumChars+1;
		ext(2) = 14;
	elseif(strcmp(ObjType,'popupmenu'))
		ext(1) = 6*NumChars+18;
		ext(2) = 14;
	elseif(strcmp(ObjType,'checkbox') | strcmp(ObjType,'radio'))
		ext(1) = 6*NumChars+16;
		ext(2) = 14;
	end
end
function len = textlen(string,units)
if(nargin<2)
	units = 'points';
end
len = zeros(size(string,1),1);
h = text('Position',[0 0],...
			'Visible','off',...
			'Units',units,...
			'FontName','Helvetica',...
			'FontSize',12);
for(i=1:size(string,1))
	set(h,'String',deblank(string(i,:)));
	extent = get(h,'Extent');
	len(i) = extent(3)+1;
end
delete(h);
