# ABM simulation script - Demo Wrapper

# F. Schiel, J. Harrington, R. Winkelmann, M. Stevens
# Based on PubilcABM.3
# version 3.4   added independent script Rcmd/postAnalysis (specific but 
#               could be used a sa template for other experiments:
#               post-experimental analysis of the log files of multiple ABMs


############################################################
# CHANGE THIS IF YOU MOVE THE EXPERIMENT TO ANOTHER COMPUTER
# to the installation dir of the package (where you see 'Rcmd') 
pfad2 = "/homes/schiel/ABM/DemoABM.1"
############################################################

# this wrapper simply runs all 4 experiments after another and
# prints some descriptions 

groupA1 = paste("S",1:10,sep="")
groupA2 = paste("S",11:20,sep="")
groupB1 = paste("S",21:30,sep="")
groupB2 = paste("S",31:40,sep="")
groupC = paste("S",41:50,sep="")
groupD = paste("S",51:60,sep="")
groupE = paste("S",61:70,sep="")

defaultSimGroups = 25
simGroupSize = 400
plotSpeakerAverage = T
dispOrig = T
speakerProb = rep(1/20,times=20)

cat("\n\n\nThis demo should demonstrate the 'Harrington effect' on artificial feature distributions in\n")
cat("a two-dimensional feature space; more specifically I want to test several cases:\n\n")

cat("\nExperiment 1a. Two equal-sized agent groups exchange the same phonological segment /x/ in the same word;\n")
cat("agents of group A2 (blue) and C (magenta) all have circular distribution with a large SD around two different means.\n")
cat("Prediction: the memory tokens of A2 and C merge into a cluster in the middle between the two means (a la Trudgill).\n\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  subsetSpeakers = c(groupA2,groupC)
  simGroups = 15
  source(paste0(pfad2,"/Rcmd/master.R"))
}

cat("\nExperiment 1b. Agents of group A1 have a narrow circular distribution with a small SD around the same mean,\n")
cat("while group B1 (magenta) have a different mean and a 5 times larger distribution in the direction of\n")
cat("the mean of A1 (the orthogonal SD is the same as in A1).\n")
cat("Prediction: the memory tokens of B1 move more in the direction of A1 than vice versa (Harrington effect).\n\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  subsetSpeakers = c(groupA1,groupB1)
  simGroups = 15
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }

  cat("\n\nThis effect is very reliable and happens every time we run the ABM.\n")
}


cat("\nExperiment 1c. Same as 1b but the distribution of group B2 is rotated by 90 degrees.\n\n")
cat("Prediction: the Harrington effect goes away, because there is no orientation towards A1 (Harrington effect)\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  subsetSpeakers = c(groupA1,groupB2) 
  simGroups = 15
  source(paste0(pfad2,"/Rcmd/master.R"))

  cat("\n\nThere is no Harrington effect. If we run this for a very long time, we'll see a mid-way merger as Trudgill would predict.\n")
}

cat("\nExperiment 2. Same group A1 interact with group C (magenta) whose agents have the same mean (but different from A)\n")
cat("and a 5 times larger circular distribution than A1.\n")
cat("Prediction: although the distribution of C is not 'directed' towards the mean of A1,\n")
cat("the memory tokens of C still move more in the direction of A1 than vice versa. Hence, the Harrington effect is not\n")
cat("only a matter of orientation but can also be caused by global SD differences.\n\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  subsetSpeakers = c(groupA1,groupC) 
  simGroups = defaultSimGroups
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }

  cat("\n\nThe effect is not as reliable as in experiment 1b (sometimes nothing happens), but if a movenment takes place it\n")
  cat("results in a quite similar merged cluster as in exp. 1b.\n")
}

cat("\nExperiment 3. Group A1 from exp. 1b (small round) interacts with group E with a distribution that looks like B1 in exp. 1b (directed towards A1)\n")
cat("Prediction: we would expect the same reliable behavior as in the previous exp. 1b: E agents should always move more in direction of A1\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  subsetSpeakers = c(groupA1,groupE)
  simGroups = defaultSimGroups
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }

  cat("\n\nThere are some difference to exp. 1b: the movement takes more interactions and the resulting merged cluster is much larger,\n")
  cat("sometimes as large as the starting E distribution, and often the mean of the merged cluster is more between the groups than near A1.\n\n")
  cat("So, what happened here? Why the different behavior from experiment 1b?\n")
  cat("The E distribution that looked like the optimal B1 distribution was in reality 10 agents\n")
  cat("with small circular distributions just like the agents in A1, but with shifted means. Let's look at the same ABM:\n")
  cat("but this time with elipses for each agent:\n\n")
}

inpu = readline("Start experiment 3 with individual elipse plots? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  plotSpeakerAverage = F
  dispOrig = F
  subsetSpeakers = c(groupA1,groupE)
  simGroups = defaultSimGroups
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }

  cat("\nWe see that first the E agents interact with each other, forming smaller elipses as a result.\n")
  cat("Then the closer E agents interact with A1 agents, but the farther away E agents don't.\n")
  cat("A1 agents are pulled in direction of E, and they all finally merge in a broader elipsoid distribution\n")
  cat("in the middle. The outcome of this experiment is more random than the classical case in 1b.\n")
}

cat("\nExperiment 4. Group A1 from exp. 1a (small round) interacts with group D with a distribution that looks like C in exp. 1a (large round)\n")
cat("Prediction: we would expect the same behavior as in the previous exp. 2: D agents reliably moves more in direction of A1.\n\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  plotSpeakerAverage = T
  dispOrig = T
  subsetSpeakers = c(groupA1,groupD)
  simGroups = defaultSimGroups
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }

  cat("\n\nIn fact, this is not quite what happens: at the beginning it seems that the Harrington rule does not work, but then\n")
  cat("sometimes the D distribution enlarges in direction of A1, but never moves significantly like in the previous experiment.\n\n")
  cat("What happened here? Why did the Harrington effect not take place? The reason is that the individual agents of D\n")
  cat("do not have all the same broad circular distribution as in C, but have narrow circular distribution just like A1 agents,\n")
  cat("but placed on a large circle that looks like a large circular distribution, if you group all D agents together.\n")
  cat("We can show this by plotting the distribution per agent as in the next repetition of experiment 4:\n\n")
}

inpu = readline("Start experiment 4 with individual elipse plots? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  plotSpeakerAverage = F
  dispOrig = F
  subsetSpeakers = c(groupA1,groupD)
  simGroups = defaultSimGroups
    inpu = ""
    while(inpu == "" || inpu == "Y" || inpu == "y") {
      source(paste0(pfad2,"/Rcmd/master.R"))
      inpu = readline("Run experiment 3 again? (Y/n) ")
    }
}

cat("We see that some D agents () after some time merge with A1 agents (blue), some don't, some even\n")
cat("merge with other D agents. The outcome of this experiment as in experiment 3 is very much random.\n")

cat("\n========================================================================================================\n\n")

readline("Continue? ")

cat("Lessons learned so far:\n")
cat("\n")
cat("1. The Harrington effect works best with asymmetric distributions between speaker groups in the same category when\n")
cat("one group distribution is oriented towards the other group. It is remarkable that this effect not only takes place,\n")
cat("when each agent has an individual skewed distribution (exp. 1b), but also when agents have individual non-skewed \n")
cat("distributions positioned in way that shows a skewed distribution on group level (exp. 3). Insofar Jonathan had the \n")
cat("correct instinct when pointing this out in the /u/-fronting Language paper, and I was wrong having doubts about this\n")
cat("(when individual agents do not have skewed distributions).\n")
cat("\n")
readline("Continue? ")

cat("2. The Harrington effect also takes place if there is no dedicated orientation towards the other group's distribution,\n")
cat("but the effect takes more time to take effect, not always happens and the result is often a larger merged distribution\n")
cat("(exp. 2). Hence, the Harrington effect is not exclusively a matter of orientation but can also be triggered by\n") 
cat("global SD differences. But in this case it is necessary that individual distributions match to each other (all agents\n")
cat("have the same big circular distribution; otherwise the effect goes away (exp. 4).\n")
cat("\n")
readline("Continue? ")

cat("3. If agent-individual distributions match to each other (all agents of a group behave the same), the Harrington effect \n")
cat("is very reliable (exp. 1b and 2). If individual mean-shifted agent distributions form a seemingly optimal distribution \n")
cat("on the group level (either an elipsoid oriented towards the other group (exp. 3) or a large circular distribution (exp.4), \n")
cat("the outcome of the ABM is not reliable and the Harrington effect is weakened if not absent (exp. 3 and 4).\n")
cat("\n")
readline("Continue? ")

cat("4. The number of agents and tokens in the ABM influence the Harrington effect. We see that for instance in exp. 4 where the \n")
cat("A1 distribution (agents all have small circular distribution around the same mean) stays stable for a long time, simply \n")
cat("because the exchanged tokens from these accumulated identical distributions are much more frequent in the ABM than tokens from \n")
cat("a single agent. With other words: the agents of A1 'enforce' each other by talking to each other frequently.\n")
cat("Therefore I would predict that a similar effect as the Harrington effect can be seen \n")
cat("in situations where the number of exchanged tokens is unbalanced (in fact we saw this in Eva's L2 learners experiments where \n")
cat("the teacher talked more frequently).\n")
cat("When designing ABM experiments this balance of exchanged tokens / number of agents has to be carefully controlled \n")
cat("to avoid 'Clever Hans' effects in situations wehre we don not expect unbalanced agent/tokens numbers.\n")
cat("On the other hand, in a genuinly un-balanced situation (teacher - students) this can be another trigger for an asymmetric\n")
cat("ABM development without any asymmetric distributions.   \n")
cat("\n")
cat("To test this we repeat the exp. 1a but agents in group C are twice as likely to speak than agents from A2.\n")

cat("\n========================================================================================================\n\n")

cat("\nExperiment 1a with different speaking probabilities.\n")
cat("Two equal-sized agent groups exchange the same phonological segment /x/ in the same word;\n")
cat("agents of group A2 (blue) and C (magenta) all have circular distribution with a large SD around two different means.\n")
cat("Agents of group C talks twice as much as agents from group A2.\n")
cat("Prediction: the memory tokens of A2 and C merge into a cluster near C.\n\n")

inpu = readline("Start experiment? (S = skip this)  ")
if( inpu != "S" && inpu != "s" ) {
  plotSpeakerAverage = T
  dispOrig = T
  subsetSpeakers = c(groupA2,groupC)
  simGroups = 15
  speakerProb = c(rep(1/30,times=10),rep(2/30,times=10))
  source(paste0(pfad2,"/Rcmd/master.R"))
}

