### All functions written by Raphael Winkelmann, except for invdct() by JMH

createPopulation <-
function(nrOfAgents=20, initMemory=NULL, dragAlongData=list()){
  
  if(is.null(initMemory) || length(initMemory)!= nrOfAgents){
    stop("length of initMemory != nrOfAgents")
  }
  
  pop = list()
  attr(pop, 'dragAlongData') = dragAlongData
  
  for(i in 1:nrOfAgents){
    pop[[i]] = list(agentNr=i, memory=initMemory[[i]])
    class(pop[[i]]) = c("agent", class(pop[[1]]))
  }
  return(pop)
}
performMultipleInteractionAndPlotEvolution <-
function(pop, prodFuncName, 
                                                         percFuncName, nrOfInteractions,
                                                         nrOfSubplots=1,
                                                         plotAt=NA, plotFuncName=NA){
  par(mfrow=c(length(plotAt),nrOfSubplots));
  #par(mfrow=c(length(plotAt),length(pop))) # for plotting results
  if(!is.na(plotFuncName)){
    plotFunc = match.fun(plotFuncName)
  }
  
  for(i in 1:nrOfInteractions){
    if(!is.na(match(i,plotAt))){
      pop = plotFunc(pop, i)
    }
    #pop = performSingleInteraction(pop, prodFuncName='produceWord', percFuncName='perceiveWord') 
    pop = performSingleInteraction(pop, prodFuncName, percFuncName)
  }
  par(mfrow=c(1,1))
  return(pop)
}
performSingleInteraction <-
function(pop, prodFuncName, percFuncName){

  # Flo 20170308 : changed from equal selection probability to agent 
  # specific selection probability:
  # If the vectors speakerProb and listenerProb are in the calling context, the 
  # probability for selecting an agent j as speaker is according to the value in 
  # speakerProb[j], and dito for the listener selection. If no vectors are in the 
  # calling context, we model equal probability accross agents (backwards 
  # compatibility).
  
  nrAg = length(pop)
  if(!exists("speakerProb")) speakerProb = rep(1/nrAg,times=nrAg)
  if(!exists("listenerProb")) listenerProb = rep(1/nrAg,times=nrAg)
  if(length(speakerProb)!=nrAg) stop("ERROR: length of speakerProb does not match number of agents")
  if(length(listenerProb)!=nrAg) stop("ERROR: length of listenerProb does not match number of agents")
  prodNr = 1
  percNr = 1  
  while(prodNr==percNr){
    prodNr = sample(1:length(pop), 1, prob=speakerProb)
    percNr = sample(1:length(pop), 1, prob=listenerProb)  
  }
  producer = pop[[prodNr]]
  perceiver = pop[[percNr]]
  
  # produce entity
  prodFunc = match.fun(prodFuncName)
  
  producedEntity = prodFunc(producer)
  
  # perceive entity
  percFunc = match.fun(percFuncName)
  
  pop[[percNr]] = percFunc(perceiver, producedEntity)
  
  return(pop)
  
}

performSingleInteraction.obsolete.20170309 <-
function(pop, prodFuncName, percFuncName){
  
  prodNr = 1
  percNr = 1  
  
  while(prodNr==percNr){
    prodNr = sample(1:length(pop), 1)
    percNr = sample(1:length(pop), 1)  
  }
  producer = pop[[prodNr]]
  perceiver = pop[[percNr]]
  
  # produce entity
  prodFunc = match.fun(prodFuncName)
  
  producedEntity = prodFunc(producer)
  
  # perceive entity
  percFunc = match.fun(percFuncName)
  
  pop[[percNr]] = percFunc(perceiver, producedEntity)
  
  return(pop)
  
}


performMultipleInteraction <-
function(pop, prodFuncName, percFuncName, nrOfInteractions,threshold = 1/3){
    
    for(i in 1:nrOfInteractions){
        #pop = performSingleInteraction(pop, prodFuncName='produceWord', percFuncName='perceiveWord')
        pop = performSingleInteraction(pop, prodFuncName, percFuncName)
    }
    return(pop)
}


invdct = function(dctcoeff, ldat)
{
    # function to recreate a time-domain signal from DCT-coefficients
    # dctcoeff: a matrix of dct-coefficients, one row per observation
    # ldat: a vector of the corresponding signal lengths corresponding to each row of dct-coefficients
    # example (requires library(emuR) )
    # plot(vowlax.fdat[10,2])
    # dct coeffs
    # v.dct = trapply(vowlax.fdat[10,2], dct, 2, simplify=T)
    # length of vowel
    # n = length(tracktimes(vowlax.fdat[10,2]))
    # obtain dct-smoothed signal
    # recon = invdct(v.dct, n)
    # compare with dct-smoothed signal obtained used dct() function
    # v.dct.smooth = trapply(vowlax.fdat[10,2], dct, 2, T, returntrack=T)
    # should be zero
    # v.dct.smooth$data - recon
resmat = NULL
if(is.matrix(dctcoeff))
mdim = ncol(dctcoeff)-1
else
mdim = length(dctcoeff)-1
for(j in 1:length(ldat)){
    if(is.matrix(dctcoeff))
cf = dctcoeff[j,]
else
cf = dctcoeff
data = transdat = c(cf, rep(0, ldat[j]-length(cf)))
m = 1:mdim
for (n in 0:(ldat[j] - 1)) {
    transdat[n + 1] <- (1/sqrt(2)) * data[1] * cos((pi *
    0 * (2 * n + 1))/(2 * ldat[j])) + sum(data[m + 1] *
    cos((pi * m * (2 * n + 1))/(2 * ldat[j])))
}
resmat = c(resmat, transdat)
}
resmat
}



