tracklinear <-
function(tdat, N = 21)
{
# tdat: a trackdata object
# N: the number of points according to which linear time normalisation is to take place
res = NULL
nsegs = nrow(tdat)
for(j in 1:nsegs)
{
x = seq(0, 1, length = nrow(tdat[j,]$data))
y = frames(tdat[j,])
omat = NULL
for(i in 1:ncol(y)){
o = approx(x, y[,i], n = N)
if(i == 1)
omat$x = o$x
omat$y = cbind(omat$y, o$y)
}
rownames(omat$y) = omat$x
res = rbind(res, omat$y)
}
colnames(res) = colnames(tdat)
rightind = seq(N, to = nsegs * N, by = N)
leftind = rightind - N + 1
leftstart = rep(0, nsegs)
rightstart = rep(1, nsegs)
as.trackdata(res, cbind(leftind, rightind), cbind(leftstart, rightstart), tdat$trackname)
}
