
# ABM simulations with Australian English sibilants (example)

# Adapted for FTP distribution:
# - removed unused packages
# - removed unused functions
# - moved necessary functions from jmh to functions

# Definition of packages, file paths
# The reason I output this in an extra file is that I want to 
# use several master scripts that all use the same basic file paths 
# and libraries. When porting the package to a new location only 
# the definitions here need to be adapted.

# set the LC-COLLATE to C
# on some Macs the collating order for IPS char is not according to the 
# locale (e.g. en_AU); to make color sequences match factor order
# we set the LC-COLLATE to C and hope that this works on all OS
Sys.setlocale("LC_COLLATE", "C")

#library(plyr)
library(MASS)
library(lattice)
library(latticeExtra)
#library(ez)
library(emuR)
library(mvtnorm)
#pfadu="http://www.phonetik.uni-muenchen.de/~jmh/lehre/Rdf"
# functions for ezAnova post-hocs
#source(file.path(pfadu, "phoc.txt"))
# function for converting trackdata to data-frame
#source(file.path(pfadu, "tracklinear.R"))
#source(file.path(pfadu, "readtrackfromurl.R"))
#source(file.path(pfadu, "tracktodf.R"))
#source(file.path(pfadu, "emu.track.S"))
# these are all fiddly functions for colour coding and legend using xyplot()
#source(file.path(pfadu, "legendxyplot.R"))
#source(file.path(pfadu, "legendxyplot_mod.R"))
#source(file.path(pfadu, "buildsegno.R"))
#source(file.path(pfadu, "buildsegnoxyplot.R"))


# sub-level directory of specific functions for this analysis
fndir = file.path(pfad2, "functions")
# functions for agent-based modelling: mostly generic
source(file.path(fndir, "agentfns.R"))
source(file.path(fndir, "equal_class.R"))
source(file.path(fndir, "splitandmerge.R"))
source(file.path(fndir, "tracklinear.R"))
source(file.path(fndir, "tracktodf.R"))
source(file.path(fndir, "buildsegno.R"))
source(file.path(fndir, "buildsegnoxyplot.R"))

# functions for agent-based modelling: mostly dependent on experiment
source(file.path(fndir, "specificAgentFunctions.R"))


