tracktodf <-
function(tdat)
{
# converts a trackdata object into a data-frame
# the output has the trackdata in successive columns
# times: the times of the frames relative to a start-time of zero
nframes = 1 + apply(tdat$index, 1, diff)
inds = rep(1:nrow(tdat), nframes)
times = tracktimes(tdat)
start.time = rep(start(tdat), nframes)
n.time = times - start.time
rownames(tdat$data) = NULL
d = data.frame(tdat$data, times = n.time, otimes = times, segno = inds)
colnames(d)[1:ncol(tdat)] = colnames(tdat)
d
}
