/***********************************************************************
************************************************************************

Module          : phondat2raw-1.0
Title           : transforms a PhonDat sound file into a raw sound file

Author          : F. Schiel
Date/revision   : 17.07.95 / 08.04.97


Description     : 
Reads a soundfile with PhonDat 1 or PhonDat 2 format from file 
phonfile, extracts the necessary
information form the header, checks whether the sound format is 
compatibel to PhonDat, strips all header information and write
outthe speech samples.
See man page for usage.
Errors are reported to stderr.

History:
1.0	: 1st version

Link modules and libraries:
ipkclib

Contained functions:
                      : 

*************************************************************************/
# ifndef FILE
# include <stdio.h>
# endif
# include <ipkclib.h>
# include <string.h>
# include <time.h>

/* DEFINES, only used within this module ********************************/

/* TYPE DEFINITIONS, only used within this module  **********************/


/* GLOBAL VARIABLES (avoid, if possible !) ******************************/


/* FUNCTION PROTOTYPES, capsuled in this module *************************/


main(int argc,const char **argv)
{
	char 	chr,*cptr,*appname,
                *rawfilnam,*phonfilnam,
		*ortho = NULL, *cano = NULL,*charpoint;
        char	buff[256],object[256],type[256],value[256],
                months[5];
	short	sample,rest,channel;
 	short	absampl = 0; 
	int	swap = 0;
	int	i,k;
 	int	readrawheader = 0, req_objects = 0;
        int 	verb = 0, bits = 0, words = 0,day = 0,month = 0,year = 0;
	long	bytes,err,skip = 0;
	long	headercount = 0, samplecount;
	FILE	*fpraw,*fpphon;
	icsiargtab_t args[] =
        {
          { 0, "1.0 : transforms a PhonDat file into a raw soundfile, "
            "\n  usage: phondat2raw phonfile=<phonf> rawfile=<rawf> [options]", ARG_DESC},
          { "v","verbose mode", ARG_BOOL, &verb },
          { "rawfile","raw file name", ARG_STR, &rawfilnam, ARG_REQ},
          { "phonfile","PhonDat file name", ARG_STR, &phonfilnam, ARG_REQ},
          { "swap","swapping short samples", ARG_BOOL, &swap},
	  {0,0,0}
	};
 	Phon_header_2 *header;
  /* Test for icsiargs if any */
  icsiargs(args,&argc,&argv,&appname);
  if(verb) printargs(stderr,appname,args);
  /* check and open outputfile */
  if((fpraw = fopen(rawfilnam,"w")) == NULL)
  {
    fprintf(stderr,"%s: error - could not open rawfile %s\n",
            appname,rawfilnam);
    exit(-1);
  }
  /* check and open inputfile */
  if((fpphon = fopen(phonfilnam,"r")) == NULL)
  {
    fprintf(stderr,"%s: error - could not open phonfile %s\n",
            appname,phonfilnam);
    exit(-1);
  }
  /* read the phondat header */
#ifdef SUNOS 
  if((header = read_header_sun(fpphon,&ortho,&cano)) == NULL)
  {
    fprintf(stderr,"%s: error - could not read phondat header from %s\n",
            appname,phonfilnam);
    exit(-1);
  }
#endif  
#ifdef LINUX
  if((header = read_header_vms(fpphon,&ortho,&cano)) == NULL)
  {
    fprintf(stderr,"%s: error - could not read phondat header from %s\n",
            appname,phonfilnam);
    exit(-1);
  }
#endif  
  /* copy samples */
  samplecount = 0;
  fseek(fpphon,header->anz_header*512,SEEK_SET);
  if(verb && swap) fprintf(stderr,"%s: swapping\n", appname);
  while(fread(&sample,sizeof(short),1,fpphon) == 1)
  {
    /* swap samples if necessary */
    if(swap)
    {
    charpoint = (char *)(&sample);
    chr = charpoint[0];
    charpoint[0] = charpoint[1];
    charpoint[1] = chr;
    }
    if(fwrite(&sample,sizeof(short),1,fpraw) != 1)
    {                                                                      
      fprintf(stderr,"%s: could not write to file %s\n", 
      appname,rawfilnam);       
      perror(appname);
      exit(-1);                                                            
    }                                                                      
    samplecount++;
  } 
  if(verb) fprintf(stderr,"%s: written %ld bytes\n",appname,
                   samplecount*2);
  if(samplecount != header->nspbk*256) 
    fprintf(stderr,"%s: warning - counted samples incorrect (%ld != %ld)\n",
            appname,samplecount,header->nspbk*256);
  return(0);
}
