function result_s = add_view_list(result_s, list_name, exp_name, source)
% function result_s = add_view_list(result_s, list_name, exp_name, source)
%
%
% CVS_Version_String = '$Id: add_view_list.m,v 1.5 2003/11/11 12:51:30 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	rec_array = get_recs_by_S_list( ['S_list_' list_name], exp_name, source, result_s);

	if ( (~isfield(result_s,'model_info')  | (~isfield(result_s.model_info,'session_lists_to_view'))) ),
		result_s.model_info.session_lists_to_view = [];
	end
	
	result_s.model_info.session_lists_to_view(end+1).set_name = list_name;
	result_s.model_info.session_lists_to_view(end).type = 'rec_list';
	result_s.model_info.session_lists_to_view(end).item = rec_array;

