function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER_version_interpl(FR_struct_data,FA_struct_data, plot_flag)
% function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = 
%           calc_EER_version_interpl(FR_struct_data,FA_struct_data, plot_flag)
%
% CVS_Version_String = '$Id: calc_EER_version_interpl.m,v 1.5 2003/12/02 12:15:54 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 2)
		plot_flag = 0;
	end

	% not implemented here
	fa_hits = 0;
	fr_hits = 0;
	fa_N_tests = 0;
	fr_N_tests = 0;

	% Bereich um Schnittpunkt, der interpoliert wird
	interpl_region = 3;
	
	%Ordnung der Polynom-Ausgleichskurve
	interpl_order_FR = 2;
	interpl_order_FA = 5;

%FA_struct_data.borders = FA_struct_data.borders - 1970;

	% gemeinsame x-Achse -> borders_common
	concat_borders = [FR_struct_data.borders FA_struct_data.borders];
	borders_common = sort(concat_borders);
	
	vector_length_fr=length(FR_struct_data.borders) - 1;
	probabilities_fr = (1:vector_length_fr) / vector_length_fr * 100;
	probabilities_fr = [0 probabilities_fr];
	
	vector_length_fa=length(FA_struct_data.borders) - 1;
	probabilities_fa = (1:vector_length_fa) / vector_length_fa * 100;
	probabilities_fa = [100 (100 - probabilities_fa)];


	% linear interpolation on common_borders
	FR_coarse_interpl = interp1(FR_struct_data.borders, probabilities_fr, borders_common, 'linear');
	FA_coarse_interpl = interp1(FA_struct_data.borders, probabilities_fa, borders_common, 'linear');



	% minimum Abstand beider Kurven, wenn EER = 0 angenommen wird
	diff_vector = diff(FR_struct_data.borders);
	minimum_sep = 2 * mean(diff_vector(1:4));
	
	if ( (FR_struct_data.borders(1) - FA_struct_data.borders(end)) > minimum_sep ),
		% keine berschneidung von FA und FR
		disp('calc_EER: branch no overlap');
		eer = 0;
		eer_coarse = 0;
		threshold = ( FR_struct_data.borders(1) - FA_struct_data.borders(end) )/ 2;
		threshold_coarse = threshold;
		if (plot_flag == 1)
			temp_figure_handle = gcf;
			figure;
			plot(borders_common,FR_coarse_interpl,'w*');
			hold on;
			plot(borders_common,FA_coarse_interpl,'y*');
			figure(temp_figure_handle);
		end
		return;
	end

	% finde ungefhren Schnittpunkt
	diff_coarse=FA_coarse_interpl - FR_coarse_interpl;
	eer_index_coarse = find(diff_coarse < 0);
	
	if (isempty(eer_index_coarse))
		eer_index_coarse = find(FR_coarse_interpl == 0);
		eer_coarse_border_index = eer_index_coarse(end);
	else
		eer_coarse_border_index = eer_index_coarse(1);
	end
	
	eer_coarse_border_index = eer_index_coarse(1);
	eer_coarse = FR_coarse_interpl(eer_coarse_border_index);
	threshold_coarse = borders_common(eer_coarse_border_index);
	
	% find coarse eer border in raw data
	
	diff_temp = probabilities_fr - FR_coarse_interpl(eer_coarse_border_index);
	FR_index_coarse = find( diff_temp < 0);
	if (isempty(FR_index_coarse))
		FR_coarse_border = 1;
	else
		FR_coarse_border = FR_index_coarse(end);
	end

	if (FR_coarse_border == 1),
		% Schnittpunkt am li. Rand von FR
		sub_FR_prob=probabilities_fr(1:4);
		sub_FR_borders=FR_struct_data.borders(1:4);

		FA_coarse_border = find( (FA_struct_data.borders >= (min(sub_FR_borders) - minimum_sep)) & (FA_struct_data.borders <= max(sub_FR_borders)) );
		sub_FA_borders = FA_struct_data.borders(FA_coarse_border);
		sub_FA_prob = probabilities_fa(FA_coarse_border);	

		stepsize = min([diff(sub_FR_borders) diff(sub_FA_borders)]);
		num_of_fine_points = (max([sub_FR_borders(end) sub_FA_borders(end)]) - min([sub_FR_borders(1) sub_FA_borders(1)])) / stepsize;
		num_of_fine_points = min([num_of_fine_points 10000]);
		sub_borders_fine=linspace(min([sub_FR_borders(1) sub_FA_borders(1)]),max([sub_FR_borders(end) sub_FA_borders(end)]),num_of_fine_points);
		
		%interpolieren
		if (length(sub_FA_borders) < (interpl_order_FA +1))
			coeff_FA=polyfit(sub_FA_borders,sub_FA_prob, 1);
		else
			coeff_FA=polyfit(sub_FA_borders,sub_FA_prob,interpl_order_FA);
		end
		coeff_FR=polyfit(sub_FR_borders,sub_FR_prob,interpl_order_FR);
		
		FA_roots = roots(coeff_FA);
		FR_roots = roots(coeff_FR);
		
		[dummy, indizes] = min(abs(FR_roots - threshold_coarse));
		FR_root = FR_roots(indizes);
		[dummy, indizes] = min(abs(FA_roots - threshold_coarse));
		FA_root = FA_roots(indizes);

		FR_interpl=polyval(coeff_FR,sub_borders_fine);
		FA_interpl=polyval(coeff_FA,sub_borders_fine);
			
		if ((isreal(FR_root)) & (isreal(FA_root)) & (FR_root > FA_root))
			disp('calc_EER: branch no overlap in fine resolution');
			eer = 0;
			threshold = ( FR_root - FA_root ) / 2;
		else
			disp('calc_EER: branch overlap on left border of fr');
			
			%erneut Schnittpunkt suchen, diesmal feiner
			diff_fine = FA_interpl - FR_interpl;
			eer_index_fine = find(diff_fine < 0);
			
			eer_fine_border_index = eer_index_fine(1);
			eer = FR_interpl(eer_fine_border_index);
			threshold = sub_borders_fine(eer_fine_border_index);		
		end
		
		
	else
		disp('calc_EER: branch overlap deep in fr');
		sub_FR_prob=probabilities_fr(FR_coarse_border-1:FR_coarse_border+2);
		sub_FR_borders=FR_struct_data.borders(FR_coarse_border-1:FR_coarse_border+2);

		FA_coarse_border = find( (FA_struct_data.borders >= min(sub_FR_borders)) & (FA_struct_data.borders <= max(sub_FR_borders)) );
		sub_FA_borders = FA_struct_data.borders(FA_coarse_border);
		sub_FA_prob = probabilities_fa(FA_coarse_border);	
	
	
		stepsize = min([diff(sub_FR_borders) diff(sub_FA_borders)]);
		num_of_fine_points = (max([sub_FR_borders(end) sub_FA_borders(end)]) - min([sub_FR_borders(1) sub_FA_borders(1)])) / stepsize;
		num_of_fine_points = min([num_of_fine_points 10000]);
		sub_borders_fine=linspace(min([sub_FR_borders(1) sub_FA_borders(1)]),max([sub_FR_borders(end) sub_FA_borders(end)]),num_of_fine_points);
		
		%interpolieren
		coeff_FA=polyfit(sub_FA_borders,sub_FA_prob,interpl_order_FA);
		coeff_FR=polyfit(sub_FR_borders,sub_FR_prob,interpl_order_FR);
	
		
		FR_interpl=polyval(coeff_FR,sub_borders_fine);
		FA_interpl=polyval(coeff_FA,sub_borders_fine);
		
		%erneut Schnittpunkt suchen, diesmal feiner
		diff_fine = FA_interpl - FR_interpl;
		eer_index_fine = find(diff_fine < 0);
		
		eer_fine_border_index = eer_index_fine(1);
		eer = FR_interpl(eer_fine_border_index);
		threshold = sub_borders_fine(eer_fine_border_index);


	end
	
	
	


	
	if (plot_flag == 1)
		if (isempty(get(0,'CurrentFigure')))
			temp_figure_handle = [];
		else
			temp_figure_handle = gcf;
		end
		figure;
		plot(sub_FR_borders,sub_FR_prob,'w*');
		hold on;
		plot(sub_FA_borders,sub_FA_prob,'y*');
		temp_axis = axis;
		plot(sub_borders_fine,FA_interpl,'g');
		plot(sub_borders_fine,FR_interpl,'g');
		axis(temp_axis);
		if (~isempty(temp_figure_handle))
			figure(temp_figure_handle);
		end
	end
	
	
	
	
	

