function [fa, fa_coarse, fr, fr_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_FR_FA_coarse(FR_struct_data,FA_struct_data, threshold, plot_flag)
% function [fa, fa_coarse, fr, fr_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_FR_FA_coarse(FR_struct_data,
%                                           FA_struct_data, threshold, plot_flag)
%
% CVS_Version_String = '$Id: calc_FR_FA_coarse.m,v 1.5 2003/12/02 12:16:24 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 3)
		plot_flag = 0;
	end


	[fr, fr_coarse, fr_hits, fr_N_tests] = find_FR_coarse(FR_struct_data, threshold,'lin_interpolation');
	[fa, fa_coarse, fa_hits, fa_N_tests] = find_FA_coarse(FA_struct_data, threshold,'lin_interpolation');
	
	if (plot_flag == 1)
		if (isempty(get(0,'CurrentFigure')))
			temp_figure_handle = [];
		else
			temp_figure_handle = gcf;
		end
		
		vector_length_fr=length(FR_struct_data.borders);
		probabilities_fr = (1:vector_length_fr) / vector_length_fr * 100;
		probabilities_fr = [0 probabilities_fr];
		
		vector_length_fa=length(FA_struct_data.borders);
		probabilities_fa = (1:vector_length_fa) / vector_length_fa * 100;
		probabilities_fa = [100 (100 - probabilities_fa)];
		
		
		figure;
		plot([FR_struct_data.borders(1) FR_struct_data.borders], probabilities_fr,'w-*');
		hold on;
		plot([FA_struct_data.borders(1) FA_struct_data.borders], probabilities_fa,'y-*');
		temp_axis = axis;
		plot(threshold,fa,'g*');
		plot(threshold,fr,'g*');
		
		threshold_coarse_index_fa = find(probabilities_fa == fa_coarse);
		threshold_coarse_fa = FA_struct_data.borders(threshold_coarse_index_fa);
		
		threshold_coarse_index_fr = find(probabilities_fr == fr_coarse);
		threshold_coarse_fr = FR_struct_data.borders(threshold_coarse_index_fr);
		
		
		plot(threshold_coarse_fa,fa_coarse,'b*');
		plot(threshold_coarse_fr,fr_coarse,'b*');
		axis(temp_axis);
		if (~isempty(temp_figure_handle))
			figure(temp_figure_handle);
		end
	end
