function llh=calc_llh_values( sv_system_name, norm_type, llhsum_type, varargin )
%
% function llh=calc_llh_values( sv_system_name, norm_type, llhsum_type, 
%    [full_calc_flag = 0,
%     full_info_flag = 0,
%     singleModel = 0,
%     mlf_file_base = 'force_aligned_',
%     x_world_store, x_cohort_test,
%     cohort_size = 3,
%     get_world_data = 0])
%
% Calculates various llh sums and std variations; return llh_struct.
% llh sums are normalized with llh sum from world model
%
% llh_struct
% -----------
% llh_struct.info = various info fields about models and sessions used for 
%					test and imp test
% llh_struct.modeldata = cell array  of data of type model_struct
%
%
% model_struct
% ------------
% model_struct.data = 	array with length equal to number of soundfiles in mlf, data is of
% 						type mlf_struct extended by the fields
% 						- data.simple_llh_sum = llh sum per soundfile
%						- data.simple_llh_sum_norm = normalized llh value according to norm_type
%						- data.simple_llh_mean (only with full_calc_flag) = mean llh sum per soundfile
%						- data.simple_llh_std (only with full_calc_flag) = mean llh std dev. per soundfile
%						- param.total_llh_sum (only with full_calc_flag) = total sum over all llh values
%						- param.total_llh_mean (only with full_calc_flag) = total mean over all llh values
%						- param.total_llh_std (only with full_calc_flag) = total std dev. over all llh values
%						- param.total_llh_length (only with full_calc_flag) = total number of all llh values
%
% model_struct.num_of_testfiles = number of soundfiles in mlf
% model_struct.model_name = name of model
% model_struct.imp_test = array  of values of type model_struct
% model_struct.imp_test.test_files_origin = name of test speaker
%
% CVS_Version_String = '$Id: calc_llh_values.m,v 1.15 2004/05/05 08:23:35 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################






	SR_lib;
	
	
	% %%%%%%%%%%%%
	% additional parameters
	if (nargin >= 11)
		get_world_data = varargin{8};
	else
		get_world_data = 0;			
	end			

	if (nargin >= 10)
		cohort_size = varargin{7};
	else
		cohort_size = 3;
	end
	
	if (nargin >= 9)
		x_cohort_test = varargin{6};
	else
		x_cohort_test = [];
	end
	
	if (nargin >= 8)
		x_world_store = varargin{5};
	else
		x_world_store = [];
	end
	
	if (nargin >= 7)
		mlf_file_base = varargin{4};
	else
		mlf_file_base = 'force_aligned_';
	end
	
	if (nargin >= 6)
		single_model = varargin{3};
	else
		single_model = 0;
	end
	
	if (nargin >= 5)
		full_info_flag = varargin{2};
	else		
		full_info_flag = 0;
	end

	if (nargin >= 4)
		full_calc_flag = varargin{1};
	else		
		full_calc_flag = 0;
	end
	
	% %%%%%%%%%%%%%%%%%%%%%
	
	
	if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
		if (isempty(x_cohort_test))
			error([mfilename ': parameter x_cohort_test not given! Needed for norm_type ''cohort max'' or ''cohort mean'' ']);
		end
	end
	if (strcmp(norm_type,'simple world') & (get_world_data ~= 1)),
		if (isempty(x_world_store))
			error([mfilename ': parameter x_world_store not given! Needed for norm_type ''simple world'' ']);
		end
	end

	
	
	
	message_header ='[calc_llh_values]: ';

	if ~(contained_in_cell(norm_type,{'simple world','cohort max','cohort mean','none'})),
		error([mesage_header 'wrong norm type']);
	end	

	if ~(strcmp(llhsum_type,'with pauses')) & ~(strcmp(llhsum_type,'without pauses')),
		error([mesage_header 'wrong llhsum type']);
	end	
	
	
	world_mlf_filename = [mlf_file_base 'client_x_world.mlf'];
	model_mlf_filename = [mlf_file_base 'client_x_model.mlf'];
	imp_test_mlf_filename_pattern = [mlf_file_base '0*_x_model.mlf'];
	cohort_mlf_filename_pattern = [mlf_file_base 'cohort_0*_x_model.mlf'];
	
	sv_system_path=strcat(basepath, sv_system_name);
	sv_system_pattern=strcat(sv_system_path,filesep,'0*');
	theDir = dir(sv_system_pattern);
	
	if length(theDir)==0,
		message = [message_header, 'Directory ', sv_system_path , ' contains no files to read!'];
		error(message);
	end
	
	[trained_models, session_details, model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'client_x_model'] );
	[imp_tested_models, imp_spks, session_details, model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'imp_x_model']);
	if (compare_cell_lists(imp_tested_models, imp_spks)),
		cross_validation_flag = 1;
	else
		cross_validation_flag = 0;
	end
	if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
		[cohort_models, cohort_test_models, cohort_session_details, model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'cohort_x_model']);
	end

	if (single_model == 0)
		llh.modeldata{length(trained_models)} = struct('data',[], 'model_name', '', 'imp_test', []);
	end
	
	if (single_model == 0),
		% durch alle trainierten Modelle durchgehen
		start_model_index = 1;
		end_model_index = length(trained_models);
	else
		% nur ein Modell
		start_model_index = single_model;
		end_model_index = single_model;	
	end
	
	llh_model_counter = 1;
	
	if ~(get_world_data),
		for i = start_model_index:end_model_index,
			start_time = fix(clock);
			%tic;
			disp([message_header ' current model: ' trained_models{i} ', starting at ' num2str(start_time(4)) ':' num2str(start_time(5)) ':' num2str(start_time(6))]);
			model_dir = strcat(sv_system_path, filesep, trained_models{i});
			model_name = trained_models{i};
				
			theImpMLFs = dir(strcat(model_dir, filesep, imp_test_mlf_filename_pattern));
	
			if length(theImpMLFs)==0,
				message = [message_header, 'Model ', model_name , ' contains no imp test files!'];
				error(message);
			end
	
	
	
			world_mlf_file = strcat(model_dir, filesep, world_mlf_filename);
			model_mlf_file = strcat(model_dir, filesep, model_mlf_filename);
				
	
	
			%%%%%%%%%%%%%%%%%%%%%%%%%%
			% world model
	
			% world llh-Werte einlesen
			%%%disp([message_header 'starting world/cohort calculation for model']);
			if (strcmp(norm_type,'simple world')),
				world_temp=calc_model_values(world_mlf_file,llhsum_type,0,0);
			end
			
			if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
				% test nur im ersten Kohorten-Verzeichnis
				cohort_model_dir = strcat(sv_system_path, filesep, cohort_models{1});
				theCohortMLFs = dir(strcat(cohort_model_dir, filesep, cohort_mlf_filename_pattern));
				if length(theCohortMLFs)==0,
					message = [message_header, 'There seems to be no cohort test files!'];
					error(message);
				end
				for c = 1:length(cohort_models),
					cohort_model_name = cohort_models{c};
					cohort_mlf_file = strcat(sv_system_path, filesep, cohort_model_name, filesep, mlf_file_base,'cohort_' ,model_name ,'_x_model.mlf');
					cohort_test(c) = calc_model_values(cohort_mlf_file,llhsum_type,0,0);
				end
			end
			%%%disp([message_header '      calculation finished; elapsed time: ' num2str(toc)]);
			
	
			%%%%%%%%%%%%%%%%%%%%%%%%%%%%
			% Modell 
			% model llh-Werte einlesen
			%%%disp([message_header 'starting calculation of model scores']);
			%%%tic
			llh.modeldata{llh_model_counter} = calc_model_values(model_mlf_file,llhsum_type,full_calc_flag,full_info_flag);
			%%%disp([message_header '      calculation finished; elapsed time: ' num2str(toc)]);
			
			% Beschreibung erzeugen
			llh.modeldata{llh_model_counter}.model_name = model_name;
	
	
	
	
			%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
			% Normierung mit World Modell / Kohorten
			%%%disp([message_header 'starting norming model scores']);
			%%%tic
			if (strcmp(norm_type,'simple world')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:length(llh.modeldata{llh_model_counter}.data),
					  world_file_index = find_file_index_in_mlf(world_temp, llh.modeldata{llh_model_counter}.data(k).file);
					  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum - world_temp.data(world_file_index).simple_llh_sum;
					  llh.modeldata{llh_model_counter}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.data(k).llh_per_frame - world_temp.data(world_file_index).llh_per_frame;
				end
			end
			if (strcmp(norm_type,'none')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:length(llh.modeldata{llh_model_counter}.data),
					  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum;
					  llh.modeldata{llh_model_counter}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.data(k).llh_per_frame;
				end
			end
			if (strcmp(norm_type,'cohort max')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:length(llh.modeldata{llh_model_counter}.data),
					% alle Kohorten Ergebnisse zu diesem Soundfile lesen 
					for c = 1:length(cohort_models),
						cohort_file_index = find_file_index_in_mlf(cohort_test(c), llh.modeldata{llh_model_counter}.data(k).file);
						cohort_temp_score_simple_sum(c) = cohort_test(c).data(cohort_file_index).simple_llh_sum;
						cohort_temp_score_per_frame(c) = cohort_test(c).data(cohort_file_index).llh_per_frame;
					end
					% dann die Besten auswhlen (hier mean aus 'cohort_size' Besten)
					temp = sort(cohort_temp_score_simple_sum);
					cohort_selected_score_simple_sum = max(temp(end - cohort_size + 1 : end));
					temp = sort(cohort_temp_score_per_frame);
					cohort_selected_score_per_frame = max(temp(end - cohort_size + 1 : end));
					
					llh.modeldata{llh_model_counter}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum - cohort_selected_score_simple_sum;
					llh.modeldata{llh_model_counter}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.data(k).llh_per_frame - cohort_selected_score_per_frame;
					
				end
			end
			if (strcmp(norm_type,'cohort mean')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:length(llh.modeldata{llh_model_counter}.data),
					% alle Kohorten Ergebnisse zu diesem Soundfile lesen 
					for c = 1:length(cohort_models),
						cohort_file_index = find_file_index_in_mlf(cohort_test(c), llh.modeldata{llh_model_counter}.data(k).file);
						cohort_temp_score_simple_sum(c) = cohort_test(c).data(cohort_file_index).simple_llh_sum;
						cohort_temp_score_per_frame(c) = cohort_test(c).data(cohort_file_index).llh_per_frame;
					end
					% dann die Besten auswhlen (hier mean aus 'cohort_size' Besten)
					temp = sort(cohort_temp_score_simple_sum);
					cohort_selected_score_simple_sum = mean(temp(end - cohort_size + 1 : end));
					temp = sort(cohort_temp_score_per_frame);
					cohort_selected_score_per_frame = mean(temp(end - cohort_size + 1 : end));
					
					llh.modeldata{llh_model_counter}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.data(k).simple_llh_sum - cohort_selected_score_simple_sum;
					llh.modeldata{llh_model_counter}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.data(k).llh_per_frame - cohort_selected_score_per_frame;
					
				end
			end
			%%%disp([message_header '      norming finished; elapsed time: ' num2str(toc)]);
	
	
			%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
			% Imp Test MLFs lesen
			%%%disp([message_header 'starting reading impostor files']);
			selected_imp_spks= {};
			j = 1;
			for current_imp_spk = 1:length(imp_spks),
				
				imp_speaker = imp_spks{current_imp_spk};
			
				%%%%%%%%%%%%%%%%%%%%%%%%%%
				% world model fr Imp Test lesen

				% imp test llh-Werte einlesen
				% beim ersten Durchgang aus File lesen, dann aus x_world_store holen (um Rechenzeit zu sparen);
				if ((i == start_model_index) & (single_model == 0)),

					if (strcmp(norm_type,'simple world')),
						x_world_mlf_file = strcat(sv_system_path, filesep, imp_speaker, filesep, world_mlf_filename);						
						x_world_store(current_imp_spk)=calc_model_values(x_world_mlf_file,llhsum_type,0,0);
					end
					
					if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
						for c = 1:length(cohort_models),
							cohort_model_name = cohort_models{c};
							x_cohort_mlf_file = strcat(sv_system_path, filesep, cohort_model_name, filesep, mlf_file_base, 'cohort_',imp_speaker ,'_x_model.mlf');
							x_cohort_test(current_imp_spk,c) = calc_model_values(x_cohort_mlf_file,llhsum_type,0,0);
						end
					end
				end

				clear calc_model_values;
				clear find_file_index_in_mlf;
				%%%disp([message_header '      clearing finished; elapsed time: ' num2str(toc)]);

				%%%disp([message_header 'reading impostor score']);
				%%%tic;
				if (strcmp(model_name, imp_speaker)),
					% do nothing
					%llh.modeldata{llh_model_counter}.imp_test{j}.data=[];
					%llh.modeldata{llh_model_counter}.imp_test{j}.test_files_origin = '';
				
				else
					selected_imp_spks{j} = imp_speaker;
					
					imp_mlf_file = strcat(model_dir, filesep, mlf_file_base,imp_speaker ,'_x_model.mlf');
					llh.modeldata{llh_model_counter}.imp_test{j} = calc_model_values(imp_mlf_file,llhsum_type,full_calc_flag,full_info_flag);
					llh.modeldata{llh_model_counter}.imp_test{j}.test_files_origin = imp_speaker;
					%%%disp([message_header '      reading finished; elapsed time: ' num2str(toc)]);
	
	
					%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
					% Imp Test Sprecher normieren
					
					% durch alle einzelnen Soundfiles gehen
					%%%disp([message_header 'starting norming of impostor score']);
					%%%tic;
					if (strcmp(norm_type,'simple world')),
						for k = 1:length(llh.modeldata{llh_model_counter}.imp_test{j}.data),
							x_world_file_index = find_file_index_in_mlf(x_world_store(current_imp_spk), llh.modeldata{llh_model_counter}.imp_test{j}.data(k).file);
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum - x_world_store(current_imp_spk).data(x_world_file_index).simple_llh_sum;
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame - x_world_store(current_imp_spk).data(x_world_file_index).llh_per_frame;
						end
					end
					if (strcmp(norm_type,'none')),
						% durch alle einzelnen Soundfiles gehen
						for k = 1:length(llh.modeldata{llh_model_counter}.imp_test{j}.data),
							  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum;
							  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame;
						end				
					end
					if (strcmp(norm_type,'cohort max')),
						% durch alle einzelnen Soundfiles gehen
						for k = 1:length(llh.modeldata{llh_model_counter}.imp_test{j}.data),
							% alle Kohorten Ergebnisse zu diesem Soundfile lesen 
							for c = 1:length(cohort_models),
								x_cohort_file_index = find_file_index_in_mlf(x_cohort_test(current_imp_spk,c), llh.modeldata{llh_model_counter}.imp_test{j}.data(k).file);
								x_cohort_temp_score_simple_sum(c) = x_cohort_test(current_imp_spk,c).data(x_cohort_file_index).simple_llh_sum;
								x_cohort_temp_score_per_frame(c) = x_cohort_test(current_imp_spk,c).data(x_cohort_file_index).llh_per_frame;
							end
							% dann die Besten auswhlen (hier mean aus 'cohort_size' Besten)
							temp = sort(x_cohort_temp_score_simple_sum);
							x_cohort_selected_score_simple_sum = max(temp(end - cohort_size + 1 : end));
							temp = sort(x_cohort_temp_score_per_frame);
							x_cohort_selected_score_per_frame = max(temp(end - cohort_size + 1 : end));
							
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum - x_cohort_selected_score_simple_sum;
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame - x_cohort_selected_score_per_frame;
							
						end
					end
					if (strcmp(norm_type,'cohort mean')),
						% durch alle einzelnen Soundfiles gehen
						for k = 1:length(llh.modeldata{llh_model_counter}.imp_test{j}.data),
							% alle Kohorten Ergebnisse zu diesem Soundfile lesen 
							for c = 1:length(cohort_models),
								x_cohort_file_index = find_file_index_in_mlf(x_cohort_test(current_imp_spk,c), llh.modeldata{llh_model_counter}.imp_test{j}.data(k).file);
								x_cohort_temp_score_simple_sum(c) = x_cohort_test(current_imp_spk,c).data(x_cohort_file_index).simple_llh_sum;
								x_cohort_temp_score_per_frame(c) = x_cohort_test(current_imp_spk,c).data(x_cohort_file_index).llh_per_frame;
							end
							% dann die Besten auswhlen (hier mean aus 'cohort_size' Besten)
							temp = sort(x_cohort_temp_score_simple_sum);
							x_cohort_selected_score_simple_sum = mean(temp(end - cohort_size + 1 : end));
							temp = sort(x_cohort_temp_score_per_frame);
							x_cohort_selected_score_per_frame = mean(temp(end - cohort_size + 1 : end));
							
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).simple_llh_sum - x_cohort_selected_score_simple_sum;
							llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame_norm =  llh.modeldata{llh_model_counter}.imp_test{j}.data(k).llh_per_frame - x_cohort_selected_score_per_frame;
							
						end
					end
					%%%disp([message_header '      norming finished; elapsed time: ' num2str(toc)]);
					j = j + 1;
				end
				
				
			end % for current_imp_spk = 1: ...
			llh.modeldata{llh_model_counter}.imp_test_spks = selected_imp_spks;
				
			llh_model_counter = llh_model_counter + 1;
			
		end % for i = start_model_index:end_model_index
	else % nur scores gegen Welt-Modell lesen
		for i = start_model_index:end_model_index,
			disp([message_header ' current model: ' trained_models{i}]);
			model_dir = strcat(sv_system_path, filesep, trained_models{i});
			model_name = trained_models{i};
				
			theWorldMLF = dir(strcat(model_dir, filesep, world_mlf_filename));
	
			if length(theWorldMLF)==0,
				message = [message_header, 'Model ', model_name , ' contains no world score files!'];
				error(message);
			end

			world_mlf_file = strcat(model_dir, filesep, world_mlf_filename);

			% world llh-Werte einlesen
			llh.modeldata{llh_model_counter} = calc_model_values(world_mlf_file,llhsum_type,full_calc_flag,full_info_flag);
			
			% Beschreibung erzeugen
			llh.modeldata{llh_model_counter}.test_files_origin = model_name;

			llh_model_counter = llh_model_counter + 1;
			
		end % for i = start_model_index:end_model_index
	
		model_dir = strcat(sv_system_path, filesep, trained_models{start_model_index});
		model_name = trained_models{start_model_index};
	
		%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
		% Imp Test World MLFs lesen
		for j = 1:length(imp_spks),
			imp_speaker = imp_spks{j};
			imp_dir = strcat(sv_system_path, filesep, imp_speaker);
			world_mlf_file = strcat(imp_dir, filesep, world_mlf_filename);
			llh.impdata{j} = calc_model_values(world_mlf_file,llhsum_type,full_calc_flag,full_info_flag);
			llh.impdata{j}.test_files_origin = imp_speaker;
		end

	end


