function [x,y] = calc_rel_hist_outline(data,varargin)
% function [x,y] = calc_rel_hist_outline(data,varargin)
%
% CVS_Version_String = '$Id: calc_rel_hist_outline.m,v 1.4 2003/11/04 10:34:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 2),
		N_hist = varargin{1};
	else
		N_hist = round(length(data)/5);
		if (N_hist < 4)
			N_hist = 4;
		end
		if (N_hist > 100)
			N_hist = 100;
		end
	end
	
	[N,centers] = hist(data,N_hist);
	[xx, yy] = stairs(centers,N);
	xx = xx';
	yy = yy';
	
	delta = centers(2)-centers(1);
	
	x = [(xx(1)-(delta/2)) (xx - (delta/2)) (xx(end)+(delta/2)) (xx(end)+(delta/2))];
	y = [0 yy yy(end) 0] /length(data);
