function [new_coeff, selected_frames] = filter_param_with_ds_tmpl(coeff, speaker, session, recording, template_dur_struct, phoneme_list)
% function [new_coeff, selected_frames] = filter_param_with_ds_tmpl(coeff, speaker, session, recording, template_dur_struct, phoneme_list)
% 
% CVS_Version_String = '$Id: filter_param_with_ds_tmpl.m,v 1.1 2004/02/23 16:50:44 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################
	
	
	short_labels = [];
	for i=1:length(phoneme_list),
		model_short_label = translate_modelname(phoneme_list{i});
		short_labels = [ short_labels model_short_label ];
	end
	
	
	for i=1:length(template_dur_struct.items)
		template_spks{i} = template_dur_struct.items{i}.spk_dir;
	end
	
		
	tmpl_spk_index = find_matching_spk_in_tmpl(template_spks, speaker);
	selected_rec_in_tmpl = find_matching_data_in_tmpl(template_dur_struct.items{tmpl_spk_index}.data, session, recording);
	template_dur_data_struct = template_dur_struct.items{tmpl_spk_index}.data(selected_rec_in_tmpl);
	[new_coeff, selected_frames] = filter_coeff_with_template(coeff, template_dur_data_struct, short_labels);
	
	
return;	
	
	
	function tmpl_spk_index=find_matching_spk_in_tmpl(template_spks, spk),
		
		tmpl_spk_index = -1;
		for i=1:length(template_spks)
			if (strcmp(template_spks{i},spk)),
				tmpl_spk_index = i;
				break;
			end
		end
		if (tmpl_spk_index == -1)
			error([mfilename ': no speaker ' spk ' found in template!']);
		end
	return;

	function selected_rec_in_tmpl = find_matching_data_in_tmpl(template_dur_data, session, recording)

		selected_rec_in_tmpl = 0;
		
		for i = 1:length(template_dur_data),
			if ( strcmp(template_dur_data(i).session, session) & strcmp(template_dur_data(i).recording, recording) ),
				selected_rec_in_tmpl = i;
				break;
			end
		end
		if (selected_rec_in_tmpl == 0),
			error([mfilename ': missing data in template; session ' session ', recording ' recording ' !!']  );
		end
			
	return;
	
	
	function [new_coeff, selected_frames] = filter_coeff_with_template(coeff, template_dur_data_struct, short_labels)
	
	
		n_frames = size(coeff, 2);
		
		model_vector=template_dur_data_struct.model_vector;
		model_offset=template_dur_data_struct.model_offset;
		dur_vector=template_dur_data_struct.dur_vector;
		
		% find matching entries in template	
		found_model_indizes=[];
		for i=1:length(short_labels),
			temp_ind=find(model_vector == short_labels(i));
			found_model_indizes=[found_model_indizes temp_ind];
		end
		
		% find corresponding starts and ends
		for i=1:length(found_model_indizes),
			if (found_model_indizes(i) < length(model_vector)),
				begin_state_block(i)=model_offset(found_model_indizes(i));
				end_state_block(i)=model_offset(found_model_indizes(i)+1) - 1;
			else
				length_state_block(i)=length(dur_vector) - model_offset(i);
				begin_state_block(i)=model_offset(found_model_indizes(i));
				end_state_block(i)=length(dur_vector);
			end
		end
	
	
		begin_times_segs=[ 1 (cumsum(dur_vector(1:end)) + 1 )];
		for i=1:length(begin_state_block),
			begin_time_filter(i)=begin_times_segs(begin_state_block(i));
			end_time_filter(i)=begin_times_segs(end_state_block(i) + 1) - 1;
		end
				
		frames_to_remove = [];
		for i=1:length(begin_time_filter),
			frames_to_remove=[frames_to_remove (begin_time_filter(i):end_time_filter(i)) ];
		end
				
		frames_to_remove = unique( frames_to_remove );
		
		complete_frames = (1:n_frames);
		
		
		selected_frames = remove_vector_items(complete_frames, frames_to_remove);
		
		new_coeff = coeff(:,selected_frames);
	
	return;	
