function draw_rec_indizes = find_sessions_in_F_struct(F_struct, search_item_sessions, search_item_spks, ext_model_info)
% function draw_rec_indizes = 
% find_sessions_in_F_struct(F_struct, search_item_sessions, search_item_spks, ext_model_info)
%
%
% CVS_Version_String = '$Id: find_sessions_in_F_struct.m,v 1.14 2004/05/04 12:37:09 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


if (~(iscell(search_item_sessions))),
	error('[find_sessions_in_F_struct]: search_item_sessions is not given as cell array');
end
if (~(iscell(search_item_spks))),
	error('[find_sessions_in_F_struct]: search_item_spks is not given as cell array');
end

search_type = 'session_list';
%keyboard;
if ((isfield(F_struct,'imp_test_spks') & isequal(search_item_spks, F_struct.imp_test_spks)) | isequal(search_item_spks,{'all'})),
	if (contained_in_cell('all', search_item_sessions)),
		draw_rec_indizes  = 1:length(F_struct.data.borders);
		return;
	end


	[search_sessions_cell, search_type] = find_combination_indizes(search_item_sessions, ext_model_info);
	
	string_array = char(F_struct.data.rec_info);
	sessions_array = string_array(:,6:7);
	
	draw_rec_indizes = [];
	if (strcmp(search_type, 'session_list'))
		for i=1:length(search_sessions_cell),
			new_indizes = strmatch(search_sessions_cell{i}, sessions_array);
			if (size(new_indizes,2) == 1)
				new_indizes = new_indizes';
			end
			draw_rec_indizes = [draw_rec_indizes new_indizes];
		end
	elseif (strcmp(search_type, 'rec_list'))
		rec_type_array = string_array(:,9:10);
		for i=1:length(search_sessions_cell),
			new_indizes_sessions = strmatch(search_sessions_cell{i}.ses, sessions_array);
			new_indizes_rec_types = strmatch(search_sessions_cell{i}.rec_type, rec_type_array);
			new_indizes = intersect(new_indizes_sessions, new_indizes_rec_types);
			if (size(new_indizes,2) == 1)
				new_indizes = new_indizes';
			end
			draw_rec_indizes = [draw_rec_indizes new_indizes];
		end
		
	end
	
	draw_rec_indizes = sort([draw_rec_indizes]);

else
% individuelle Liste fuer Auswahl an Sprechern
	if (contained_in_cell('all', search_item_sessions)),
		search_sessions_cell = ext_model_info.training_session_details.sessions_evaluate_array;
		search_type = ext_model_info.training_session_details.type;
	else
		[search_sessions_cell, search_type] = find_combination_indizes(search_item_sessions, ext_model_info);
	end
	
	string_array = char(F_struct.data.rec_info);
	sessions_array = string_array(:,6:7);
	spk_array = string_array(:,1:4);

	spk_match_rec_indizes = [];
	for i=1:length(search_item_spks),
		new_indizes = strmatch(search_item_spks{i}, spk_array);
		if (size(new_indizes,2) == 1)
			new_indizes = new_indizes';
		end
		spk_match_rec_indizes = [spk_match_rec_indizes new_indizes];
	end

	if (strcmp(search_type, 'session_list'))
		draw_rec_indizes = [];
		for i=1:length(search_sessions_cell),
			new_indizes = strmatch(search_sessions_cell{i}, sessions_array);
			new_indizes = intersect(new_indizes, spk_match_rec_indizes);
			if (size(new_indizes,2) == 1)
				new_indizes = new_indizes';
			end
			draw_rec_indizes = [draw_rec_indizes new_indizes];
		end
	elseif (strcmp(search_type, 'rec_list'))
		draw_rec_indizes = [];
		rec_type_array = string_array(:,9:10);
		for i=1:length(search_sessions_cell),
			new_indizes_sessions = strmatch(search_sessions_cell{i}.ses, sessions_array);
			new_indizes_rec_types = strmatch(search_sessions_cell{i}.rec_type, rec_type_array);
			new_indizes = intersect(new_indizes_sessions, new_indizes_rec_types);
			new_indizes = intersect(new_indizes, spk_match_rec_indizes);
			if (size(new_indizes,2) == 1)
				new_indizes = new_indizes';
			end
			draw_rec_indizes = [draw_rec_indizes new_indizes];
		end
		
	end

	draw_rec_indizes = sort([draw_rec_indizes]);

	
end



function [search_sessions_cell, search_type] = find_combination_indizes(search_item_sessions, ext_model_info)
	search_sessions_cell_trainingConf_session_type = {};
	search_sessions_cell_trainingConf_rec_type = {};
	search_sessions_cell_lists_session_type = {};
	search_sessions_cell_lists_rec_type = {};
	st_tr='';
	st_pr='';
	
	for i = 1:length(search_item_sessions),
		if (strcmp(search_item_sessions{i}, 'without training')),
			
			search_sessions_cell_trainingConf = get_diff_sessions_array(ext_model_info.training_session_details.sessions_evaluate_array, ext_model_info.training_session_details.sessions_training_array);
			if (strcmp(ext_model_info.training_session_details.type, 'session_list'))
				search_sessions_cell_trainingConf_session_type = search_sessions_cell_trainingConf;
				st_tr = 's';
			else
				search_sessions_cell_trainingConf_rec_type = search_sessions_cell_trainingConf;
				st_tr = 'r';
			end
		
		elseif (strcmp(search_item_sessions{i}, 'training')),

			search_sessions_cell_trainingConf = ext_model_info.training_session_details.sessions_training_array;
			if (strcmp(ext_model_info.training_session_details.type, 'session_list'))
				search_sessions_cell_trainingConf_session_type = search_sessions_cell_trainingConf;
				st_tr = 's';
			else
				search_sessions_cell_trainingConf_rec_type = search_sessions_cell_trainingConf;
				st_tr = 'r';
			end
			
		else
			session_list_index = find_index_in_sessions_list( ext_model_info.preDefined,search_item_sessions{i} );
			
			if (strcmp(ext_model_info.preDefined{session_list_index}.type,'session_list')),
				search_sessions_cell_lists_session_type = {search_sessions_cell_lists_session_type{:} ext_model_info.preDefined{session_list_index}.item{:} };
				if (~(strcmp(st_pr,'r')))
					st_pr = 's';
				end
			else
				search_sessions_cell_lists_rec_type = {search_sessions_cell_lists_rec_type{:} ext_model_info.preDefined{session_list_index}.item{:} };
				st_pr = 'r';
			end
			
		end
	end

	% trainingConf Listen auswhlen (nur eine mglich)
	if (strcmp(st_tr,'s')),
		search_sessions_cell_trainingConf = search_sessions_cell_trainingConf_session_type;
	else
		search_sessions_cell_trainingConf = search_sessions_cell_trainingConf_rec_type;
	end
	
	% nur listen aus trainingConf
	if (strcmp(st_pr,''))
		search_sessions_cell = search_sessions_cell_trainingConf;
		if (strcmp(st_tr,'s')),
			search_type = 'session_list';
		else
			search_type = 'rec_list';
		end
		return;
	end

	
	% session lists und rec lists zusammenfassen
	if (strcmp(st_pr,'r')),
		search_sessions_cell_lists = search_sessions_cell_lists_rec_type;
		
		session_lists_conv = expand_session_list(search_sessions_cell_lists_sesssion_type);
		search_sessions_cell_lists = {search_sessions_cell_lists{:} session_lists_conv{:}};
		
	else
		search_sessions_cell_lists = search_sessions_cell_lists_session_type;
	end
	
	% nur listen aus lists
	if (strcmp(st_tr,''))
		search_sessions_cell = search_sessions_cell_lists;
		if (strcmp(st_pr,'r'))
			search_type = 'rec_list';
		else
			search_type = 'session_list';
		end
		return;
	end

	
	if (strcmp(st_tr,'s') & strcmp(st_pr,'s'))
		search_sessions_cell = intersect(search_sessions_cell_trainingConf, search_sessions_cell_lists);
	else
		if (strcmp(st_tr,'s')),
			tr_part = expand_session_list(search_sessions_cell_trainingConf);
			expanded_list = 'tr';
		else
			tr_part =  search_sessions_cell_trainingConf;
		end
		if (strcmp(st_pr,'s')),
			pr_part = expand_session_list(search_sessions_cell_lists);
			expanded_list = 'pr';
		else
			pr_part = search_sessions_cell_lists;
		end
		
		search_sessions_cell = {};
		
		if (strcmp(expanded_list,'pr')),
			for i=1:length(tr_part),
				for j=1:length(pr_part),
					if (strcmp(tr_part{i}.ses, pr_part{j}.ses) & strcmp(tr_part{i}.rec_type, pr_part{j}.rec_type))
						search_sessions_cell = {search_sessions_cell{:} tr_part{i}};
					end
				end
			end
		else % expanded_list = 'tr'
			for i=1:length(tr_part),
				for j=1:length(pr_part),
					if (strcmp(tr_part{i}.ses, pr_part{j}.ses) & strcmp(tr_part{i}.rec_type, pr_part{j}.rec_type))
						search_sessions_cell = {search_sessions_cell{:} pr_part{i}};
					end
				end
			end
		end
		search_type = 'rec_list';
		
	end

	
function expanded_list = expand_session_list(session_list)
	
	expanded_list = {};
	for i=1:length(session_list),
		for rec_counter=1:7,
			rec_type = ['P' num2str(rec_counter)];
			rec = ['dummmy' rec_type '.param'];
			ses = session_list{i};
			temp_struct = struct('rec',rec,'rec_type',rec_type,'ses',ses);
			expanded_list = {expanded_list{:} temp_struct};
		end
	
	end
