function fd_struct=load_feature_distribution( filename)
% fd_struct=load_feature_distribution( filename)
%
% CVS_Version_String = '$Id: load_feature_distribution.m,v 1.4 2003/12/10 20:00:46 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	total_lines = length(line_array);

	fd_struct.feature=[];
	
	fd_id = 0;
	search_info_flag = 0;
	search_hist = 0;
	
	for line = 1:total_lines,

		tmp_line = line_array{line};
		
		if (findstr('Feature', tmp_line)),
			begin_num = findstr('Feature',tmp_line);
			fd_id = sscanf(tmp_line(begin_num(1)+7:end), '%d');
			search_info_flag = 1;
		else
		
		
			if (search_info_flag),
				values = sscanf(tmp_line,'%d %f %f');
				fd_struct.feature(fd_id).bin_size = values(1);
				fd_struct.feature(fd_id).min_exp = values(2);
				fd_struct.feature(fd_id).max_exp = values(3);
				search_info_flag = 0;
				search_hist = 1;
			else
	
				if (search_hist),
					search_hist = 0;
					fd_struct.feature(fd_id).histogram = sscanf(tmp_line,'%d');
					fd_struct.feature(fd_id).histogram = fd_struct.feature(fd_id).histogram / sum(fd_struct.feature(fd_id).histogram);
				end
			end
			
		end

	end % for line ...
	fd_struct.filename = filename;


