function mark_imp(imp)
% function mark_imp(imp)
%
% CVS_Version_String = '$Id: mark_imp.m,v 1.5 2004/05/05 12:00:47 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	ud = get(gca,'UserData');
	if (~(isempty(ud))) & isfield(ud,'handle'),
		delete(ud.handle);
		ud_new=[];
		set(gca,'UserData',ud_new);
	end
 
	if (isempty(ud)) | (isfield(ud,'imp') & (imp ~= ud.imp)),
		y_lim = get(gca,'YLim');
		y_upper_lim = y_lim(2);
		h=patch([imp-0.5 imp-0.5 imp+0.5 imp+0.5 imp-0.5 imp-0.5 imp+1.5 imp+1.5 imp-1.5 imp-1.5 imp-0.5],[(y_upper_lim - 0.5) 0.5 0.5 (y_upper_lim - 0.5) (y_upper_lim - 0.5) (y_upper_lim + 0.5) (y_upper_lim + 0.5) -0.5 -0.5 (y_upper_lim + 0.5) (y_upper_lim + 0.5)],ones(1,11),1);
		set(h,'FaceColor',[0.4 0.4 0.4],'EdgeColor','none');
		set(h,'ButtonDownFcn',['mark_imp(' num2str(imp) ')']);
		ud.handle = h;
		ud.imp = imp;
		set(gca,'UserData',ud);
	end

