function [sampling_freq, ...
      audio_type, ...
	  audio_file_ext, ...
	  label_file_ext] = read_database_description
% function [sampling_freq, ...
%     audio_type, ...
%	  audio_file_ext, ...
%	  label_file_ext] = read_database_description
%
%
% CVS_Version_String = '$Id: read_database_description.m,v 1.2 2004/02/13 08:43:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	  
	doc_path = getenv('MASV_DATABASE_DESCRIPTION');
	file_name = [ doc_path 'MASV_db_desc.pm'];
	line_array=textread(file_name,'%s','delimiter','\n','whitespace','');

	total_lines = length(line_array);

	sampling_freq = [];
	frame_duration = [];
	audio_file_ext = [];
	label_file_ext = [];
	audio_type = [];

	for i=1:total_lines,
		current_line=line_array{i};
		if (~isempty(strmatch('$sampling_freq',current_line))),
			sign_index = findstr('=', current_line);
			semicolon_index =findstr(';', current_line);
			
			remain = current_line(sign_index(1)+1:semicolon_index(1)-1);
			sampling_freq=str2num(remain);

		elseif (~isempty(strmatch('$audio_file_ext', current_line))),
			quote_indizes=findstr('"', current_line);
			remain = current_line(quote_indizes(1)+1:quote_indizes(2)-1);
			audio_file_ext=remain;
			
		elseif (~isempty(strmatch('$label_file_ext', current_line))),
			quote_indizes=findstr('"', current_line);
			remain = current_line(quote_indizes(1)+1:quote_indizes(2)-1);
			label_file_ext=remain;

		elseif (~isempty(strmatch('$audio_type', current_line))),
			quote_indizes=findstr('"', current_line);
			remain = current_line(quote_indizes(1)+1:quote_indizes(2)-1);
			audio_type=remain;
		end

	end

