function [sets] = read_spk_set(sv_system_name)
%
% function [sets] = read_spk_set(sv_system_name)
%
% Read spkset file from links directory and get sets.
%
% CVS_Version_String = '$Id: read_spk_set.m,v 1.8 2004/02/13 13:21:12 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	SR_lib;
	
	
	if (strcmp(sv_system_name, 'revert to standard set')),
		info_file = 'standard';
		path_info_file = fullfile(basepath, '..', 'templates', 'speaker_sets');
	else
		info_file = 'currentSpeakerSet';
		path_info_file = fullfile(basepath, sv_system_name, 'links');
	end
	
	
	info_filename = fullfile(path_info_file, info_file);
	
	line_cell=textread(info_filename,'%s','delimiter','\n','whitespace','');
	
	
	%%%%%%%%%%%%%%%%%%%%%%%%%
	% read speakerlist
	%%%%%%%%%%%%%%%%%%%%%%%%%
	set_counter = 1;
	
	for i=1:length(line_cell),
		line = line_cell{i};
		speakerlist_border = findstr(line, '$speakerlist{');
		if ( not (isempty(speakerlist_border))),
			speakerlist_end_border = findstr(line,'}');
			
			set_name = line(speakerlist_border(1)+1+12:speakerlist_end_border(1)-1);
			
			sets{set_counter}.set_name = set_name;
			
			% search for single quote
			quote_border = findstr(line, '''');
			item_counter = 1;
			for dir_counter = 1:2:length(quote_border),
				dir_item = line(quote_border(dir_counter)+1:quote_border(dir_counter+1)-1);
				sets{set_counter}.item{item_counter}=dir_item;
				item_counter = item_counter + 1;
			end
			
			set_counter = set_counter + 1;
		
		end
	
	end
	
	sets{set_counter}.set_name = 'all';
	sets{set_counter}.item = [ get_set(sets,'training_set')  get_set(sets, 'test_set')  get_set(sets,'dev_set')  get_set(sets,'world_set')];

	set_counter = set_counter + 1;
	sets{set_counter}.set_name = 'all_tt';
	sets{set_counter}.item = [ get_set(sets,'training_set') get_set(sets, 'test_set') ];
	
	set_counter = set_counter + 1;
	sets{set_counter}.set_name = 'all_training';
	sets{set_counter}.item = [ get_set(sets,'training_set')];

	set_counter = set_counter + 1;
	sets{set_counter}.set_name = 'all_test';
	sets{set_counter}.item = [ get_set(sets,'test_set')];

	set_counter = set_counter + 1;
	sets{set_counter}.set_name = 'all_hnorm';
	sets{set_counter}.item = [ get_set(sets,'training_set') get_set(sets, 'test_set') ];

