function play_sound_file( subject, session, recording, varargin)
% function play_sound_file( subject, session, recording, [time_struct for playing segment])
%
% CVS_Version_String = '$Id: play_sound_file.m,v 1.2 2004/02/17 09:43:59 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;

	full_name = fullfile(rawdatapath, subject, session, recording);
	
	rate=sampling_freq; % defined in MASV_db_desc.pm
	
	if (nargin == 4)
		time_struct=varargin{1};
		start_time = time_struct.start;
		end_time = time_struct.end;
		part_length = end_time - start_time;
		% all times are in msec
	end
	
	if (strcmp(computer,'MAC'))
	
		raw_lin = read_raw_alaw(full_name);
		
		if (nargin == 4)
			raw_lin = raw_lin(start_time*(rate/1000)+1:end_time*(rate/1000)+1);
		end
		sound(raw_lin,rate,8);
	else
		if (nargin == 4)
		    [scriptpath 'play_sound_part_remote.sh ' full_name ' ' num2str((rate/1000)*start_time) ' ' num2str((rate/1000)*part_length)]
			unix([scriptpath 'play_sound_part_remote.sh ' full_name ' ' num2str((rate/1000)*start_time) ' ' num2str((rate/1000)*part_length)]);
		else
			unix([scriptpath 'play_sound_remote.sh ' full_name]);
		end
	end
