#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

$CVS_Version_String = '$Id: calculate_sn_ratio.pl,v 1.9 2004/02/05 10:47:09 tuerk Exp $';
$CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $Identify = 0;
my $help = 0;

GetOptions('version' => \$Identify,
			'help|?' => \$help);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}


if ((@ARGV != 2) || ($help)) {
   pod2usage(1);
   exit 1;
}


my $mlf_file = $ARGV[0];

my $method = $ARGV[1];

if (!( -e $mlf_file)) { 
	die("$mlf_file not found!\n");
}
	

if ( ($method ne "mlf_segments") && ($method ne "time_based_segments") ){

	die("use 'mlf_segments' or 'time_based_segments' for method!\n");
}

($signalBeginRef, $signalEndRef, $signalSoundfilesRef, $silenceBeginRef, $silenceEndRef, $silenceSoundfilesRef) = &get_noiseSignal_segments($mlf_file, $method); 


my @signalRMS = ();
my @silenceRMS = ();

# signal part
for (my $segment_counter=0; $segment_counter<=$#$signalSoundfilesRef; $segment_counter++) {
	$current_part_filename = "${SR_lib::source_wav_files}${$signalSoundfilesRef}[$segment_counter]";
	#print $current_part_filename, "\n";
	$inPoint = ${$signalBeginRef}[$segment_counter] * $MASV_db_desc::sampling_freq / 1000;
	$outPoint = ${$signalEndRef}[$segment_counter] * $MASV_db_desc::sampling_freq / 1000;
	$exec_string = "sox -t raw -r $MASV_db_desc::sampling_freq -s -b -A -c 1 $current_part_filename -t wav - trim ${inPoint}s ${outPoint}s | sox -t wav - -e stat 2> /tmp/calculate_sn_ratio.txt";
	#print "$exec_string \n\n\n";
	$exit_state = system($exec_string);
	
	#print $exit_state , "\n";
	
	$fh = open_file("<", "/tmp/calculate_sn_ratio.txt");
		@temp = <$fh>;
	close $fh;
	
	@foundlist = grep (/RMS\s*amplitude/, @temp);
	$foundlist[0] =~ /(\d*\.\d*)/;
	$rms = $1;
	#print "$rms \n";
	
	push @signalRMS, $rms;
}

for (my $segment_counter=0; $segment_counter<=$#$silenceSoundfilesRef; $segment_counter++) {
	$current_part_filename = "${SR_lib::source_wav_files}${$silenceSoundfilesRef}[$segment_counter]";
	#print $current_part_filename, "\n";
	$inPoint = ${$silenceBeginRef}[$segment_counter] * $MASV_db_desc::sampling_freq / 1000;
	$outPoint = ${$silenceEndRef}[$segment_counter] * $MASV_db_desc::sampling_freq / 1000;
	$exec_string = "sox -t raw -r $MASV_db_desc::sampling_freq -s -b -A -c 1 $current_part_filename -t wav - trim ${inPoint}s ${outPoint}s | sox -t wav - -e stat 2> /tmp/calculate_sn_ratio.txt";
	#print "$exec_string \n\n\n";
	$exit_state = system($exec_string);
	
	#print $exit_state , "\n";
	
	$fh = open_file("<", "/tmp/calculate_sn_ratio.txt");
		@temp = <$fh>;
	close $fh;
	
	@foundlist = grep (/RMS\s*amplitude/, @temp);
	$foundlist[0] =~ /(\d*\.\d*)/;
	$rms = $1;
	#print "$rms \n";
	
	push @silenceRMS, $rms;
}

my $meanSilenceRMS = 0;
my $meanSignalRMS = 0;

foreach $currentRMS (@silenceRMS) {
	$meanSilenceRMS += $currentRMS;
}
$meanSilenceRMS /= scalar @silenceRMS;

foreach $currentRMS (@signalRMS) {
	$meanSignalRMS += $currentRMS;
}
$meanSignalRMS /= scalar @signalRMS;


$fh = open_file(">", "calculate_sn_ratio_result_${mlf_file}.txt");

print $fh "\n\n";
print $fh "mean signal rms: $meanSignalRMS \n";
print $fh "mean signal rms: $meanSilenceRMS \n";
print $fh "s/n ratio [dB]: ", 10 * ( log($meanSignalRMS / $meanSilenceRMS) / log(10) ), "\n";
print $fh "\n\n";

close $fh;

my @snr_array = ();

$snr_array[$_] = 10 * ( log($signalRMS[$_] / $silenceRMS[$_]) / log(10) ) for (0 .. $#signalRMS);


$fh = open_file(">", "calculate_sn_ratio_data_${mlf_file}.txt");

for (0 .. $#snr_array) {
	print $fh ${$signalSoundfilesRef}[$_] ,":", $snr_array[$_], "\n";
}

close $fh;

exit 0;



sub get_noiseSignal_segments {
	my $template_mlf = $_[0];
	my $segment_mode = $_[1];
	
	my @template = ();
	
	$fh = open_file("<", "$template_mlf");
		@template = <$fh>;
	close $fh;
	
	####
	# !!
	# all frames here are a frame of 1 ms!
	# times from mlf (in 100 ns units) are converted to the frame used here 
	# !!
	
	my $current_rec;
	my $current_rec_full_path;
	my $current_path;
	my $current_part;
	my $current_line;
	my $allowed_flag = 0;
	
	for (my $counter=1;$counter<=$#template;$counter++) {
		$current_line = $template[$counter];
		if ($current_line =~ /"(.*)"/) {
			$current_rec_full_path = $1;
			$current_rec_full_path =~ s/\.rec/\.${MASV_db_desc::audio_file_ext}/;
			$current_rec_full_path =~ s/\.lab/\.${MASV_db_desc::audio_file_ext}/;
			# letzten 22 Zeichen geben den Soundfile-Namen an.
			$current_rec = substr($current_rec_full_path, length($current_rec_full_path) - 20);
			$found_silStart = 0;
			$found_silEnd = 0;
		}
		elsif (($current_line =~ /^\d+\s+\d+/)) {

			@temp_fields = split (/\s+/,$current_line);
			$begin_frame = int(($temp_fields[0] / 10000)+0.5);
			$end_frame = int(($temp_fields[1] / 10000)+0.5);
			$label =  $temp_fields[2];
			
			if ($label eq "silStart") {
				$found_silStart = 1;
				$current_silStart_end = $end_frame;
			}
			elsif ($label eq "silEnd") {
				$found_silEnd = 1;
			}
		}
		elsif (($current_line =~ /^\./)) {
			if ($segment_mode eq "mlf_segments") {
				if ($found_silStart) {
					push @silenceBegin, 0;
					push @silenceEnd, $current_silStart_end;
					push @silenceSoundfiles, $current_rec;
				}
				if ($found_silEnd) {
					push @silenceBegin, $begin_frame;
					push @silenceEnd, $end_frame;
					push @silenceSoundfiles, $current_rec;
				}
				
				if ($found_silStart && $found_silEnd) {
					push @signalBegin, $current_silStart_end;
					push @signalEnd, $begin_frame;
					push @signalSoundfiles, $current_rec;
				}
				elsif ($found_silStart && (!$found_silEnd)) {
					push @signalBegin, $current_silStart_end;
					push @signalEnd, $end_frame;
					push @signalSoundfiles, $current_rec;
					
				}
			}
			elsif ($segment_mode eq "time_based_segments") {
				$end_frame = int( (stat("${SR_lib::source_wav_files}$current_rec"))[7] * 1000 / $MASV_db_desc::sampling_freq );
				push @silenceBegin, ($end_frame - 1000); # last second
				push @silenceEnd, $end_frame;
				push @silenceSoundfiles, $current_rec;
				
				push @signalBegin, 1000; # time period between first and third second
				push @signalEnd, 3000;
				push @signalSoundfiles, $current_rec;
				
			}
			
		}
	}
	return (\@signalBegin, \@signalEnd, \@signalSoundfiles, \@silenceBegin, \@silenceEnd, \@silenceSoundfiles);
}



__END__

=head1 NAME

calculate_sn_ratio.pl  - create table with snr values for each recording from mlf

=head1 SYNOPSIS

calculate_sn_ratio.pl mlf_file method

Use a mlf_file (also mlf_realized possible) as list of recordings. For these recordings
the snr-value is computed by two alternative methods: timebase (time_based_segments) uses
last second of recording as silence, and the time period between 1s and 3s as speech part;
mlf_segments silStart and silEnd segments given in a recognizer/force_aligned mlf.


