#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: create_MASV_paramPool.pl,v 1.3 2004/02/23 10:22:33 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';



use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;


###########################
# Default values for options
my $help = 0;
my $Identify = 0;
my @typearray = ('P[1-7]');
my @speakerarray = ();
my @speakertestarray = ();
###########################
my @typearray_temp;

my $scriptfile_handle;
my @joined_speaker_list=();


# Processing Options

GetOptions('t|typesession=s' => \@typearray_temp, 's|speakers=s' => \@speakerarray,
           'help|?' => \$help,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 1) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $poolname = $ARGV[0];


if (@typearray_temp) {
	@typearray = @typearray_temp;
}


my $outdir=$SR_lib::paramPool_dir.$poolname.$SR_lib::sign;

my $scriptoutdir = $outdir . 'scripts' . $SR_lib::sign;	  
my $configdir = $outdir . 'configs' . $SR_lib::sign;

# generate list of session types
@typearray = split(/,/,join(',',@typearray));

# generate list of speakers
@speakerarray = split(/,/,join(',',@speakerarray));

foreach my $speakerlist_id (@speakerarray) {
   push (@speakertestarray, @{$SR_lib::speakerlist{$speakerlist_id}});
}
if (!@speakertestarray) {
   @speakertestarray = ('all');
}


opendir SRCDIR, $SR_lib::source_wav_files;
my @speaker_dirs = grep(/^\d{4}$/, readdir (SRCDIR));
closedir SRCDIR;


#check Paths
&SR_lib::check_and_create_dir($outdir);
&SR_lib::check_and_create_dir($scriptoutdir);
&SR_lib::check_and_create_dir($configdir);



$scriptfile_handle = &SR_lib::open_file(">", "${scriptoutdir}S_pool_${poolname}_selected_speakers");


foreach my $speaker_dir (@speaker_dirs) {
	foreach my $speaker_allowed (@speakertestarray) {
		if ( ($speaker_dir eq $speaker_allowed ) || ($speaker_allowed eq "all") ) {
			&write_S_list_entries_4_speaker($speaker_dir, $outdir, $scriptfile_handle, \@typearray);
		} # end if ( ($speaker_dir eq $speaker_allowed ) || ($speaker_allowed eq "all") )   
	} # end foreach $speaker_allowed    
} # end foreach $speaker_dir (@speaker_dirs) {

close $scriptfile_handle;


 
my $all_handle = &SR_lib::open_file(">", "${scriptoutdir}S_pool_${poolname}");
foreach my $speaker_dir (@SR_lib::all) {

	&write_S_list_entries_4_speaker($speaker_dir, $outdir, $all_handle, \@typearray);

} # end foreach $speaker_dir ... {
close $all_handle;
  
 
exit 0;



sub write_S_list_entries_4_speaker {
	
	my $speaker_dir = $_[0];
	my $outdir = $_[1];
	my $S_file_handle = $_[2];
	my $typearray_ref = $_[3];
	
    #check Path
    my $outpath=$outdir.$speaker_dir;
    &SR_lib::check_and_create_dir($outpath);
    
			 
    opendir SRCDIR, "${SR_lib::source_wav_files}$speaker_dir";
    my @ses_dirs = grep ( /\d{2}/o, readdir (SRCDIR));
    closedir SRCDIR;

		foreach my $ses_dir (@ses_dirs) {
		
			#check Out-Path
			$outpath=$outdir.$speaker_dir.$SR_lib::sign.$ses_dir;
			&SR_lib::check_and_create_dir($outpath);
			
			
			opendir SRCDIR, "${SR_lib::source_wav_files}${speaker_dir}${SR_lib::sign}$ses_dir";
			my @src_files = grep(/${MASV_db_desc::audio_file_ext}$/o, readdir(SRCDIR));
			close SRCDIR;

			foreach my $src_file (@src_files) {
				foreach my $session_type (@$typearray_ref) {
					if ($src_file =~ /(.*$session_type)\.${MASV_db_desc::audio_file_ext}$/) {
						my $base_src_file = $1;
							 
						print $S_file_handle "${SR_lib::source_wav_files}${speaker_dir}${SR_lib::sign}${ses_dir}${SR_lib::sign}$src_file ";
						print $S_file_handle "$outdir" . "$speaker_dir" ."$SR_lib::sign" . "$ses_dir" . "$SR_lib::sign" . "$base_src_file" . ".param\n";
							 
					}	
				}
			}				# end foreach $src_file (@src_files)
		
		}				# end foreach $ses_dir (@ses_dirs)

}



__END__

=head1 NAME

create_MASV_paramPool.pl  - create configuration scripts for HCopy for a new parameter pool

=head1 SYNOPSIS

create_MASV_paramPool.pl [options] poolname

Creates script files for HCopy with name "S_pool_<poolname>".
Speech files are read from <ENV::MASV_SOURCE_DATABASE>; output path for script files 
is the generated directory "<ENV::MASV_PARAMPOOL_DIR>/<poolname>/scripts/".
Script files are generated for
- the selected speakers from the -s option
- for all speakers of the corpus
The scripts contain all recordings of the given type (-t) of all available sessions.

 Options:
 -t | typesession = s     specify type of recordings.
                          default: 'P[1-7]' (all triple numbers of VeriDat)
 -s | speakers = s        specify set of speakers;
                          Default: speaker set "@all" as defined in the template file
                          "<ENV::MASV_BASEDIR>/templates/speaker_sets/standard".
                          Include additional sets here.
                          
 -? | help                display this message.
 
=cut

