#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: get_bestWorldModel.pl,v 1.9 2004/02/17 15:36:39 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my %results;

my $help = 0;
my $Identify = 0;

GetOptions('help|?' => \$help,
           'version' => \$Identify);


if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}


if ((@ARGV != 2) || ($help)) {
   pod2usage(1);
   exit 1;
 }
 

my $sv_system_name = $ARGV[0];
my $hmmBaseDir = $ARGV[1];

my $test_files_dir = "${SR_lib::sv_systems_dir}${sv_system_name}/world/";
opendir SRCDIR, $test_files_dir;
my @test_files = grep(/^hresults_test_${hmmBaseDir}.*\.txt/, readdir (SRCDIR));
closedir SRCDIR;

if ((scalar @test_files) == 0) {
	exit 1;
}

my $hmm_version;

foreach my $test_file (@test_files)
{
	$test_file =~ /hresults_test_${hmmBaseDir}_(\d+)/;
	$hmm_version = $1;
	
	# File lesen
	my $test_handle = &SR_lib::open_file("<", "$test_files_dir" . "$test_file");
	my @test_file_content = <$test_handle>;
	close $test_handle;
	
	#Accuracy bestimmen
	#print $test_file_content[6], "\n";
	$test_file_content[6] =~ /^WORD:\ %Corr=(\d+\.\d+)/;
	$results{$hmm_version} = $1;
	#print "$hmm_version, $results{$hmm_version} \n";

}

my $best_version = (sort sorting_num (keys(%results)))[0];
my $current_perf = $results{$best_version};
# print "current_perf: $current_perf \n";

foreach my $key (sort sorting_num (keys(%results))) {
	#print "current key: $key \n";
	if ($results{$key} >= $current_perf) {
		$best_version = $key;
		$current_perf = $results{$key}
	} else {
		last;
	}
	
}

print STDOUT "$best_version\n";

exit 0;

sub sorting_num { 
	my $retval;

	if ($a > $b) { 
		$retval = 1;
	} 
	elsif ($a == $b) {
		$retval = 0;
	} 
	else { 
		$retval = -1;
	}
	$retval; 
}


__END__

=head1 NAME

get_bestWorldModel.pl  - gets best world model from HResult files.

=head1 SYNOPSIS

get_bestWorldModel.pl  sv_system_name  hmmBaseDir

Reads given HResults files and finds the version which gives
the first maximum of the word accuracy.

Note: the files generated with "HResults" must reside in the "world/" 
directory of the SV system <sv_system_name> and their name must start 
with the string
"hresults_test_<hmmBaseDir>_<version_of_model>"
and end with the extension ".txt".

=cut

