#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: loop_thru_featuresets.pl,v 1.5 2004/03/30 13:31:33 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Cwd;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $exit_state = 0;

###########################
# Default values for options
my $help = 0;
my $Identify = 0;

###########################
# Processing Options

# flat
GetOptions('help|?' => \$help,
		   'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 3) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $script_name = $ARGV[0];
my $feature_set_list = $ARGV[1];
my $sv_system_name = $ARGV[2];

my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";

my $feature_set_path = "${sv_system_path}${SR_lib::sign}feature_sets${SR_lib::sign}";

my $bash_binary = `which bash`;
chomp($bash_binary);

unless (open(FILE, "${feature_set_path}${feature_set_list}") ) {
	die "feature set list   $feature_set_list  not found!\n\n";
}
my @feature_set_list_entries = <FILE>;
close FILE;

my @feature_set_name = ();
my @feature_set_incl = ();
my @feature_set_excl = ();

foreach my $line (@feature_set_list_entries) {
	chomp($line);
	next if ($line =~ /^\s*\#/);
	my @elements = split(/\t+/, $line);
	next if ( (scalar @elements) != 3 );
	$elements[0] =~ s/\s*//g;
	$elements[1] =~ s/\s*//g;
	$elements[2] =~ s/\s*//g;
	push (@feature_set_name, $elements[0]);
	push (@feature_set_incl, $elements[1]);
	push (@feature_set_excl, $elements[2]);
}


foreach my $feature_set_counter ( 0 .. $#feature_set_name) {
	
	&create_C_files($sv_system_path,  ${feature_set_incl[$feature_set_counter]}, ${feature_set_excl[$feature_set_counter]});
	
	&SR_lib::change_matlab_calc_script($script_name, "_${feature_set_name[$feature_set_counter]}");
	
	print STDERR "=====================================\n";
	print STDERR "New feature set: ${feature_set_name[$feature_set_counter]}, incl. ${feature_set_incl[$feature_set_counter]}, excl. ${feature_set_excl[$feature_set_counter]} \n\n";
	#print STDERR "proceed?\n";
	#my $line = <STDIN>;
	$exit_state += system("$bash_binary $script_name"); 
}
# reset matlab startup file
&SR_lib::change_matlab_calc_script($script_name, "");

print STDERR "=====================================\n";
print STDERR "Finished loop thru feature sets. \n\n";


exit $exit_state;



sub create_C_files {
	my ($sv_system_path, $incl_string, $excl_string) = @_;
	my $fh;
	my ($incl_print_string, $excl_print_string);

	$incl_print_string = ($incl_string && !($incl_string eq "all")) ? "-include_features=$incl_string" : "";
	$excl_print_string = ($excl_string  && !($incl_string eq "none")) ? "-exclude_features=$excl_string" : "";

	
	my $C_file_path = "${sv_system_path}feature_sets${SR_lib::sign}C_for_HCompV";
	
	$fh = &SR_lib::open_file(">", "$C_file_path");
	print $fh "HSHELL: HPARMFILTER = 'cut_features -use_USER_format $incl_print_string $excl_print_string \\\$ -'\n";
	print $fh "HSHELL: HMMDEFFILTER = 'mod_hmm.pl -use_USER_format $incl_print_string $excl_print_string \\\$ -'\n";
	close $fh;
	
	
	$C_file_path = "${sv_system_path}feature_sets${SR_lib::sign}C_for_HERest";
	
	$fh = &SR_lib::open_file(">", "$C_file_path");
	print $fh "HSHELL: HPARMFILTER = 'cut_features -use_USER_format $incl_print_string $excl_print_string \\\$ -'\n";
	close $fh;
	
}




__END__

=head1 NAME

loop_thru_featuresets.pl  - repeat a script for different feature sets

=head1 SYNOPSIS

loop_thru_featuresets.pl [options] script_name  feature_set_list  sv_system_name

Repeat a shell script for the given feature sets. The feature sets
are listed in a file (feature_set_list), one entry per line.
Each line contains the name of the feature set, a comma seperated list of features
to be included and a comma seperated list of features to be excluded. Comment lines
( starting with # ) are ignored.

 Options:

 -version                 print version information.

 -? | help                display this message.
 
=cut

