function box_handle = create_legend_box(info)
% function box_handle = create_legend_box(info)
%
% CVS_Version_String = '$Id: create_legend_box.m,v 1.5 2004/02/03 14:27:54 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	
	temp_axes_handle = gca;
	pos = [0.2 0.80 0.08 0.03];



	box_handle=axes('position',pos);
	set(box_handle,'Box','on');
	set(box_handle,'CLimMode','manual');
	set(box_handle,'XTickLabelMode','manual');
	set(box_handle,'XTickMode','manual');
	set(box_handle,'XTick',-1);
	set(box_handle,'YTickLabelMode','manual');
	set(box_handle,'YTickMode','manual');
	set(box_handle,'YTick',-1);
	set(box_handle,'YLim',[0 length(info)]);
	
	set(box_handle,'Tag','legend');
	ud.posdata = [];
	set(box_handle,'UserData',ud);
	
	set(box_handle,'ButtonDownFcn','moveaxis');

	x_size = 2;
	y_size = 1;
	for i = 1:length(info),
		ht=text(0,0,info{i});
		set(ht,'Units','characters');
		pos=get(ht,'position');
		pos(1)=1;
		pos(2)=length(info)-i + 0.8;
		set(ht,'position',pos);
		extent=get(ht,'Extent');
		x_size=max([ x_size, extent(3) ]);
		y_size=max([ y_size, ( length(info)-i + extent(4) ) ]);
	end
	x_size = x_size + 1;
	y_size = y_size + 0.3;
	set(box_handle,'Units','characters');
	
	
	pos=get(box_handle,'position');
	pos(3)=x_size;
	pos(4)=y_size;
	set(box_handle,'position',pos);
	%set(box_handle,'Units','normalized');
	
	set(gcf,'currentaxes',temp_axes_handle);

