function s_neu =  HTK_FFT(s,invert)

	TPI = 2*pi;
	
   n=length(s);
   nn=n / 2;
   j = 1;
   for ii=1:nn 
      i = 2 * ii - 1;
      if (j>i)
         xre = s(j);
		 xri = s(j + 1);
         s(j) = s(i);
		 s(j + 1) = s(i + 1);
         s(i) = xre;
		 s(i + 1) = xri;
	 end
      m = n / 2;
     while ((m >= 2)  & (j > m))
         j = j - m;
		 m = m / 2;
	 end
     j = j + m;
  end
  
  limit = 2;
  while (limit < n)
      inc = 2 * limit;
	  theta = TPI / limit;
      if (invert)
		  theta = -theta
	  end
      x = sin(0.5 * theta);
      wpr = -2.0 * x * x;
	  wpi = sin(theta); 
      wr = 1.0;
	  wi = 0.0;
      for ii=1:(limit/2)
         m = 2 * ii - 1;
         for jj = 0:((n - m) / inc)
            i = m + jj * inc;
            j = i + limit;
            xre = wr * s(j) - wi * s(j + 1);
            xri = wr * s(j + 1) + wi * s(j);
            s(j) = s(i) - xre;
			s(j + 1) = s(i + 1) - xri;
            s(i) = s(i) + xre;
			s(i + 1) = s(i + 1) + xri;
		end
         wx = wr;
         wr = wr * wpr - wi * wpi + wr;
         wi = wi * wpr + wx * wpi + wi;
	 end
      limit = inc;
  end
   
  if (invert)
      for i = 1:n 
         s(i) = s(i) / nn;
	  end
  end

  s_neu=s;