function coeff = HTK_SigP_FBank2MFCC(fbank,numCeps,mode)
% function coeff = HTK_SigP_FBank2MFCC(fbank,numCeps, mode)
%
% CVS_Version_String = '$Id: HTK_SigP_FBank2MFCC.m,v 1.1 2004/03/29 14:02:17 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

   	if (strcmp(mode,'HTK')),
		numChans = length(fbank);
		mfnorm = sqrt(2/numChans);
		pi_factor = pi/numChans;
		c=zeros(numCeps,1);
		x=(1:numCeps) * pi_factor;
		for j=1:numCeps
			%c(j) = 0.0;
			%x = j * pi_factor;
			for k=1:numChans
				c(j) = c(j) + fbank(k) * cos(x(j)*(k-0.5));
			end
			%c(j) = c(j) * mfnorm;
		end
		coeff=c*mfnorm;
	else
		coeff=dct(fbank);
		coeff=coeff(2:(numCeps+1));
	end

return;


