function [x,y] = calc_counting_hist_outline(data, norm_mode,smooth_step)
% function [x,y] = calc_counting_hist_outline(data, norm_mode, smooth_step)
%
% CVS_Version_String = '$Id: calc_counting_hist_outline.m,v 1.5 2004/01/27 17:56:34 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	if (isempty(data)),
		x=[];
		y=[];
		return;
	end
	
	sorted = unique(data);
	data_min=sorted(1);
	data_max=sorted(end);
	i = 1;
	for j=data_min:smooth_step:data_max,
		N(i)=length(find(data == j));
		centers(i) = j;
		i=i+1;
	end
	[xx, yy] = stairs(centers,N);
	xx = xx';
	yy = yy';
	
	delta = centers(2)-centers(1);
	
	x = [(xx(1)-(delta/2)) (xx - (delta/2)) (xx(end)+(delta/2)) (xx(end)+(delta/2))];
	if (strcmp(norm_mode, 'norm area')),
		norming_factor = sum(data);
	else
		norming_factor = 1;
	end
	y = [0 yy yy(end) 0] / norming_factor;
