function distance=calc_model_distance(client_model_array, world_model, mean_over_spks, feature_set_struct, mixture_mode, distance_type, part_type)
% function distance=calc_model_distance(client_model_array, world_model, 
%                     mean_over_spks, feature_set_struct, mixture_mode, distance_type, part_type) 
% 
% CVS_Version_String = '$Id: calc_model_distance.m,v 1.4 2004/04/07 18:37:13 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	
	distances=[];
	
	selected_client_models=client_model_array(mean_over_spks);
	

	filtered_world_model = mod_hmm( world_model, feature_set_struct.include_list, feature_set_struct.exclude_list );

	for i = 1:length(selected_client_models),
				
				
			filtered_client_model = mod_hmm( selected_client_models{i}, feature_set_struct.include_list, feature_set_struct.exclude_list );
			
			switch distance_type,
				case 'bhattacharyya'
					distance_value = bhattacharyya_distance_GMM( filtered_client_model, filtered_world_model, mixture_mode, part_type );
				case 'divergence'
					distance_value = divergence_distance_GMM( filtered_client_model, filtered_world_model, mixture_mode );
			end
		
			distances(i) = distance_value;
			
	end
	
	distance=mean(distances);
	
	
	
