function dur_struct=durStat2matlab( filename )
% dur_struct = durStat2matlab( filename)
%
%
%
% CVS_Version_String = '$Id: durStat2matlab.m,v 1.3 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	dur_struct = [];
	
	fid = fopen(filename,'r');
	if (fid == -1)
		return;
	end
	fclose(fid);

	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	line_counter = length(line_array);

	file_start_indizes = strmatch('"', line_array);
	file_end_indizes = strmatch('.', line_array);

	if ~(length(file_start_indizes) == length(file_end_indizes))
		error(['durStat2matlab: dur stat file ' filename ' is not well formed!']);
	end
	
	block_start=file_start_indizes(1);
	tmp_file = line_array{block_start}(2:(end-1));
	slash_index_array = findstr(filesep, tmp_file);
	speaker = tmp_file(1:(slash_index_array(1) - 1));
	session = tmp_file((slash_index_array(1) + 1):(slash_index_array(2) - 1));
	recording = tmp_file((slash_index_array(2) + 1):end);
	% test first entry
	first_file_first_line=line_array{file_start_indizes(1)+1};
	field_borders = findstr(first_file_first_line, ',');
	
	if (isempty(field_borders)),
		error(['statDur2matlab: first line in first file block of stat dur file ' filename ' is not well formed!']);
	end
	if (length(field_borders) == 2)
		% do nothing 
	else
		error(['statDur2matlab: wrong format in file ' filename ]);
	end
	
	for file_counter = 1:(length(file_start_indizes)),
		block_start=file_start_indizes(file_counter);
		block_end=file_end_indizes(file_counter);

		tmp_file = line_array{block_start}(2:(end-1));
		speaker = tmp_file(1:(slash_index_array(1) - 1));
		session = tmp_file((slash_index_array(1) + 1):(slash_index_array(2) - 1));
		recording = tmp_file((slash_index_array(2) + 1):end);
		
		dur_struct_data(file_counter).speaker = speaker;
		dur_struct_data(file_counter).session = session;
		dur_struct_data(file_counter).recording = recording;
		
		state_counter = 1;
		
		dur_vector_temp = [];
		state_vector_temp = [];
		model_vector_temp = [];
		model_offset_temp = [];
		
		for line_index = block_start+1:block_end-1,
			line = line_array{line_index};
			field_borders = findstr(line, ',');
			if (isempty(field_borders)),
				error(['statDur2matlab: stat dur file block starting at line ' block_start ' in file ' filename ' is not well formed!']);
			end
			current_model = translate_modelname(line(1:field_borders(1)-1));
			current_state_dur = sscanf(line(field_borders(1)+1:field_borders(2)-1),'%d');
			current_state = sscanf(line(field_borders(2)+1 : end),'%d');
			
			if (line_index == block_start+1),
				prev_model = current_model;
				model_vector_temp = [current_model ];
				model_offset_temp = [1];
			end
			if ( prev_model == current_model),
				% do nothing
			else
				model_vector_temp = [model_vector_temp current_model ];
				model_offset_temp = [model_offset_temp state_counter ];
			end

			dur_vector_temp(state_counter) = current_state_dur;
			state_vector_temp(state_counter) = current_state;

			prev_model = current_model;
			state_counter = state_counter + 1;
			
		end
		dur_struct_data(file_counter).model_vector = model_vector_temp;
		dur_struct_data(file_counter).model_offset = model_offset_temp;
		dur_struct_data(file_counter).dur_vector = dur_vector_temp;
		dur_struct_data(file_counter).state_vector = state_vector_temp;
		
		clear translate_modelname;
		
	end % for file_counter
	dur_struct.data = dur_struct_data;
	
	

