function [sessions_lists] = load_SR_lib_pm_sets
%
% function [sessions_lists] =  load_SR_lib_pm_sets
%
% Read SR_lib.pm from scripts directory and get session lists:
%	$sessions_lists{}
%
% CVS_Version_String = '$Id: load_SR_lib_pm_sets.m,v 1.10 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################




	global basepath scriptpath;

	doc_path = getenv('MASV_DATABASE_DESCRIPTION');
	perl_file = [ doc_path 'MASV_db_desc.pm'];
	
	
	fid = fopen(perl_file,'r');
	if fid==-1,
		error('Cannot open MASV_db_desc.pm file');
	end
	
	%read line by line
	
	set_block_end_found = 0;
	set_block_begin_found = 0;
	set_counter = 1;
	session_lists_counter = 1;
	training_lists_counter = 1;
	evaluate_lists_counter = 1;
	while ( set_block_end_found == 0 )
	
		line = fgetl(fid);
		tmp_borders = findstr(line, 'begin used also by matlab');
		if ( not (isempty(tmp_borders))),
			set_block_begin_found = 1;
		end
		
		tmp_borders = findstr(line, 'end used also by matlab');
		if ( not (isempty(tmp_borders))),
			set_block_end_found = 1;
		end
		
		if (set_block_end_found == 1) & (set_block_begin_found == 0),
			error('Error in SR_lib.pm!!');
		end
		
		if (set_block_begin_found == 1) & ( set_block_end_found == 0),
		

			%%%%%%%%%%%%%%%%%%%%%%%%%
			% read sessions_lists
			%%%%%%%%%%%%%%%%%%%%%%%%%
			borders = findstr(line, '$sessions_lists{');
			if ( not (isempty(borders))),
				lists_end_border = findstr(line,'}');
				
				set_name = line(borders(1)+1+15:lists_end_border(1)-1);
				
				sessions_lists{session_lists_counter}.set_name = set_name;
				sessions_lists{session_lists_counter}.type = 'session_list';
				
				% search for single quote
				quote_border = findstr(line, '''');
				item_counter = 1;
				for dir_counter = 1:2:length(quote_border),
					dir_item = line(quote_border(dir_counter)+1:quote_border(dir_counter+1)-1);
					sessions_lists{session_lists_counter}.item{item_counter}=dir_item;
					item_counter = item_counter + 1;
				end
				
				session_lists_counter = session_lists_counter + 1;
			
			end



		end
		
	end % while