function time_struct = recompute_dea_time_mapping(time_struct, paramPoolConfig)

		SR_lib;
		
		rec_info = time_struct.rec_info;

		slash_indizes=findstr(rec_info,'/');
		subject = rec_info(1:slash_indizes(1)-1);
		session = rec_info(slash_indizes(1)+1:slash_indizes(2)-1);
		recording = rec_info(slash_indizes(2)+1:end);
		
		search_pattern = strcat(rawdatapath, subject, filesep, session, filesep, '*', recording,'.', audio_file_ext);
		dir_struct = dir(search_pattern);
		
		if ( ~(isempty(dir_struct) & (length(dir_struct) == 1)) ),
			filename = dir_struct.name;
			filename = fullfile(rawdatapath, subject, session, filename);
			%process the file
			wave=read_raw_alaw(filename);
			wave=wave * 4096;
			[wave_sd, border_info]=HTK_SigP_SilenceDetection( wave, paramPoolConfig);
			
			period = paramPoolConfig.sourceRate / 1000; % rate in  1 / (samples per 100 mu sec)
			offset_time_start = round( border_info.spDetStart_samples * period ); % time in 100 mu sec
			offset_time_end = round( border_info.spDetEnd_samples * period );
			
			time_struct.start = time_struct.start + offset_time_start;
			time_struct.end = time_struct.end + offset_time_start;
			
			
			
		end
