function SR_Testbed(varargin)

% colors:

my_grey = [0.7 0.7 0.7];
my_red = [0.8 0 0];
my_dark_green = [0.3 0.5 0.3];
my_green = [0 9 0];


if (nargin==1)
	action = varargin{1};
else
	action = 'init';
end

switch action

	case 'init'
			
			fh=init_screen;
			
			draw_functions = {'Standard Setting'};
			temp_handle = findobj(gcf,'Tag','functions');
			set(temp_handle, 'String',draw_functions);

            value = get(findobj(gcf,'Tag','functions'), 'Value');
            theFunction = draw_functions{value};
			
			
			return;
			
	case 'init conf'
			
			config = get(gcf, 'UserData');

			N_training = length(config.training_conf);

			cm_handle = findobj(gcf,'Tag','audio_recordmenu');
			
			i = 1;
			xi_max = 7;
			yi_max = 4;
			for yi = 1:yi_max
				for xi=1:xi_max
				
					xpos = 30 + 60*(xi-1) ;
					ypos = 110 - 20*(yi-1);
					lab_string = config.training_conf(i).label_string;
					audio_h = uicontrol('Parent',gcf, ...
						'Units','points', ...
						'Position',[xpos ypos 60 20], ...
						'String',lab_string, ...
						'Tag','audio_training', ...
						'FontSize',9, ...
						'UserData', '', ...
						'UIContextMenu', cm_handle, ...
						'Callback','SR_Testbed(''audio_training_button'');');
					i = i + 1;
					if (i > N_training),
						return;
					end
				end
			end
			
	case 'delete exp conf'
			temp_handle = findobj(gcf, 'Tag','audio_training');
			delete(temp_handle);
			
	
	case 'record'
			current_button = gco;
			current_label = get(current_button,'String');
			set(current_button, 'BackgroundColor',my_red);
			% record
			set(current_button, 'BackgroundColor',my_dark_green);

			
	case 'play'
			current_button = gco;
			current_label = get(current_button,'String');
			set(current_button, 'BackgroundColor', my_green);
			% play
			set(current_button, 'BackgroundColor',my_dark_red);
			
			
			
			
			
	case 'delete'
			current_button = gco;
			current_label = get(current_button,'String');
			
			set(current_button, 'BackgroundColor',my_grey);
			

			
	
	case 'choose exp'
				
			temp_path = pwd;
					
			temp_handle = findobj(gcf,'Tag','Choose_Button');
			lastUsedPath = get(temp_handle, 'UserData');
					
			if (isempty(lastUsedPath))
				lastUsedPath = '';
			end
			[filename, used_path] = uigetfile([lastUsedPath '*.*'],'Select an image:');
			
			if (used_path ~= 0)
				lastUsedPath = used_path;

				set(temp_handle, 'UserData', lastUsedPath);
				cd(temp_path);
				
			end
			
			
			for i=1:4,
				config.training_conf(i).label_string = num2str(i);
			end
			
			set(gcf,'UserData',config);
			
			SR_Testbed('delete exp conf');
			SR_Testbed('init conf');
            
end




function figure_handle=init_screen

	if (strcmp(computer,'MAC'))
		pos = [30 200 680 535];
	else
		pos = [15    65   800   650];
	end
	colordef black;
	
	figure_handle = figure('Color',[0.1 0.1 0.1], ...
		'Position',pos, ...
		'Tag','mainFigure');
	axes_handle_orig = axes('Parent',figure_handle, ...
		'Units','points', ...
		'Box','on', ...
		'FontSize',9, ...
		'Position',[30 180 400 300], ...
		'Tag','theAxes');
	choose_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[440 100 40 20], ...
		'String','load', ...
		'Tag','Choose_Button', ...
		'UserData', '', ...
		'Callback','SR_Testbed(''choose exp'');');
	function_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[1 1 1], ...
		'Position',[440 180 140 80], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','functions', ...
		'Callback','SR_Testbed(''switch_function'')');
		
	audio_handle = uicontextmenu('Parent',figure_handle, ...
		'Tag','audio_recordmenu', ...
		'Visible','off');
	
	a_menu1 = uimenu(audio_handle,'Label','record','Callback','SR_Testbed(''record'')');
	a_menu2 = uimenu(audio_handle,'Label','delete','Callback','SR_Testbed(''delete'')');
