function result_struct = calc_FR_FA(sv_system_name, ...
									result_name, ...
									full_calc_flag, ...
									full_info_flag, ...
									incl_world_flag, ...
									norm_type, ...
									llhsum_type, ...
									score_type, ...
									varargin)
%
% function result_struct = calc_FR_FA
%                         (sv_system_name,
%                         result_name,
%                         full_calc_flag,
%                         full_info_flag,
%                         incl_world_flag,
%                         norm_type,
%                         llhsum_type,
%                         score_type,
%                         [mlf_file_base = 'force_aligned_', ...
%							cohort_size = 3])
%
%
% builds a result_struct containing the FR and FA values for the sv_system
% 'sv_system_name'. The result_name is used when searching for an existing .mat-file
% in the results directory. If none is found, the result_struct is calculated. 
%
% result_struct
% -------------
% result_struct.FR_struct   a FR_struct cell array (no. of trained models)
% result_struct.FA_struct   a FA_struct cell array (no. of trained models)
% result_struct.exp_name    the name of the sv_system
% result_struct.result_name the name of the result
%
% FR_struct
% ---------
% FR_struct.data.borders         a vector with normalized llh values, where a
%                                test was done. Length is No. of tests.
% FR_struct.data.rec_info        info string for all test, containing model, session and 
%                                recording.
% 
% FR_struct.model_name           name of the model/speaker
%
% if calculated with flag 'full_info_flag' set:
% FR_struct.data.mlf_data      array of mlf_value structs, size: length of borders vector.
%
% mlf_value
% ---------
% mlf_value.start_vector         vector of all starting time of all phonemes of the force
%                                alignment
% mlf_value.end_time             end point of last phoneme
% mlf_value.phoneme_vector       cell vector with the phoneme labels
%     
%  length of the  vectors: no. of labels in the recording
%
%
% FA_struct
% ---------
% FA_struct.data                 see FR_struct (including mlf_value extension)
% 
% CVS_Version_String = '$Id: calc_FR_FA.m,v 1.18 2004/05/05 08:23:35 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 8),
		cohort_size = 3;
		mlf_file_base = 'force_aligned_';
	elseif (nargin == 9)
		mlf_file_base = varargin{1};
		cohort_size = 3;
	elseif (nargin == 10)
		mlf_file_base = varargin{1};
		cohort_size = varargin{2};
	end
	
	SR_lib;
	[sets] = read_spk_set(sv_system_name);

	if (~(strcmp(score_type,'simple sum')) & (~(strcmp(score_type,'per frame')))),
		error('Wrong type for score_type; use ''simple sum'' or ''per frame''!');
	end

	num_of_models = get_num_of_trained_models(sv_system_name, mlf_file_base);
	
	% initialize FR_struct and FA_struct
	FR_struct{num_of_models}=[];
	FA_struct{num_of_models}=[];


	sv_system_path=strcat(basepath, sv_system_name);

	[trained_models, training_session_details, model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'client_x_model'] );
	[imp_tested_models, imp_test_spks, imp_session_details, imp_tested_model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'imp_x_model'] );
	if (compare_cell_lists(imp_tested_models, imp_test_spks)),
		cross_validation_flag = 1;
	else
		cross_validation_flag = 0;
	end
	
	if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
		[cohort_models, cohort_test_models, cohort_session_details, cohort_model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'cohort_x_model'] );
	elseif (strcmp(norm_type,'simple world') | (incl_world_flag)),
		[world_tested_models, world_models, world_session_details, world_model_version] = read_force_aligned_config(sv_system_name, [mlf_file_base 'client_x_world'] );
	end
	
	
	% gehe durch alle trainierten Modelle
	for model = 1:num_of_models,
			clear mlf2matlab;
			clear calc_llh_values;
			clear calc_model_values;
			
			%%%%%%%%%%%%%%%% Welt/Kokorten Scores in temp-Variablen
			%%%%             beschleunigt Berechnung
			%%%%%%%%%%%%%%%%
			
			if (strcmp(norm_type,'none')),
				x_world_store = [];
				x_cohort_test = [];
			end

			if ((model == 1) & (~strcmp(norm_type,'none'))),

				world_mlf_filename = [mlf_file_base 'client_x_world.mlf'];
				
				disp('Calculating temp. array for world/cohort scores...');

				for j = 1:length(imp_test_spks),
					imp_speaker = imp_test_spks{j};
					if (strcmp(norm_type,'simple world')),
						x_world_mlf_file = fullfile(sv_system_path, imp_speaker, world_mlf_filename);						
						x_world_store(j)=calc_model_values(x_world_mlf_file,llhsum_type,0,0);
					end
					
					if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
						for c = 1:length(cohort_models),
							cohort_model_name = cohort_models{c};
							x_cohort_mlf_file = strcat(sv_system_path, filesep, cohort_model_name, filesep, mlf_file_base,'cohort_',imp_speaker ,'_x_self.mlf');
							x_cohort_test(j,c) = calc_model_values(x_cohort_mlf_file,llhsum_type,0,0);
						end
					end
				end

				if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
					x_world_store = [];
				end
				if (strcmp(norm_type,'simple world')),
					x_cohort_test = [];
				end
			end
			
			%%%%%%%%%%%%%%%%
			%%%%%%%%%%%%%%%%
			
			
			
			llh_struct_single = calc_llh_values(sv_system_name,norm_type, llhsum_type, full_calc_flag,full_info_flag,model,mlf_file_base,x_world_store, x_cohort_test, cohort_size);
		    disp(['calc_FR_FA; calculation FR/FA; current model: ',int2str(model),' of ',int2str(num_of_models)]);	
			if (strcmp(score_type,'simple sum')),
				FR_temp_array=[llh_struct_single.modeldata{1}.data.simple_llh_sum_norm];
			end
			if (strcmp(score_type,'per frame')),
				FR_temp_array=[llh_struct_single.modeldata{1}.data.llh_per_frame_norm];
			end
			FR_temp_rec_array=char({llh_struct_single.modeldata{1}.data.file});
			[temp_struct, index_sort]=count_cdf_with_borders(FR_temp_array,FR_temp_rec_array);
			FR_struct{model}.data = temp_struct;

			FR_struct{model}.data.duration = [llh_struct_single.modeldata{1}.data.duration];
			FR_struct{model}.data.duration = FR_struct{model}.data.duration(index_sort);
			
			FR_struct{model}.model_name=llh_struct_single.modeldata{1}.model_name;
			if (full_info_flag)
				FR_struct{model}.data.mlf_data=struct('start_vector',{llh_struct_single.modeldata{1}.data.start_vector}, 'end_time', {llh_struct_single.modeldata{1}.data.end_time}, 'phoneme_vector',{llh_struct_single.modeldata{1}.data.phoneme_vector});
				FR_struct{model}.data.mlf_data = FR_struct{model}.data.mlf_data(index_sort);
			end		

			FA_temp_array =[];
			FA_temp_rec_cell = {};
			FA_temp_mlf_data = [];
			FA_temp_durations = [];
			for index_impSpeaker = 1:length(llh_struct_single.modeldata{1}.imp_test)
				%if (~ strcmp(llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.test_files_origin,'')), % not filtered in cross val.
				
				if (strcmp(score_type,'simple sum')),
					FA_temp_array_singleImpSpk = [llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.simple_llh_sum_norm];
				end
				if (strcmp(score_type,'per frame')),
					FA_temp_array_singleImpSpk = [llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.llh_per_frame_norm];
				end
				
				FA_temp_array=[FA_temp_array FA_temp_array_singleImpSpk];
				FA_temp_rec_cell_singleImpSpk = {llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.file};
				FA_temp_rec_cell={FA_temp_rec_cell{:} FA_temp_rec_cell_singleImpSpk{:}};
				FA_temp_durations=[FA_temp_durations llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.duration];
				if (full_info_flag)
					if (index_impSpeaker == 1)
						FA_temp_mlf_data = struct('start_vector',{llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.start_vector}, 'end_time', {llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.end_time}, 'phoneme_vector',{llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.phoneme_vector});
					else
						FA_temp_mlf_data=[FA_temp_mlf_data struct('start_vector',{llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.start_vector}, 'end_time', {llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.end_time}, 'phoneme_vector',{llh_struct_single.modeldata{1}.imp_test{index_impSpeaker}.data.phoneme_vector})];
					end
				end				
				
			
			end
			
			FA_temp_rec_array=char(FA_temp_rec_cell);
			[temp_struct, index_sort]=count_cdf_with_borders(FA_temp_array,FA_temp_rec_array);
			FA_struct{model}.data = temp_struct;
			FA_struct{model}.data.duration = [FA_temp_durations];
			FA_struct{model}.data.duration = FA_struct{model}.data.duration(index_sort);
			if (full_info_flag)
				FA_struct{model}.data.mlf_data=[FA_temp_mlf_data];
				FA_struct{model}.data.mlf_data=FA_struct{model}.data.mlf_data(index_sort);
			end		


			FA_struct{model}.model_name=llh_struct_single.modeldata{1}.model_name;
			FA_struct{model}.imp_test_spks=llh_struct_single.modeldata{1}.imp_test_spks;
			
			%loeschen
			clear llh_struct_single;
	end


	if (incl_world_flag),
		clear mlf2matlab;
		clear calc_llh_values;
		clear calc_model_values;
		disp(['calc_FR_FA; calculation of extra world data']);
		dummy = [];
		world_llh_struct = calc_llh_values(sv_system_name,norm_type, llhsum_type,full_calc_flag,full_info_flag,0,mlf_file_base,dummy,dummy,cohort_size, 1);
		world_struct = struct('modeldata', [], 'impdata', []);
		% gehe durch alle trainierten Modelle
		for model = 1:num_of_models,
			if (strcmp(score_type,'simple sum')),
				world_temp_score_array = [world_llh_struct.modeldata{model}.data.simple_llh_sum];
			end
			if (strcmp(score_type,'per frame')),
				world_temp_score_array = [world_llh_struct.modeldata{model}.data.llh_per_frame];
			end
			world_temp_rec_array=char({world_llh_struct.modeldata{model}.data.file});
			[temp_struct, index_sort]=count_cdf_with_borders(world_temp_score_array,world_temp_rec_array);
			world_struct.modeldata{model}=temp_struct;
			
			world_struct.modeldata{model}.test_files_origin=world_llh_struct.modeldata{model}.test_files_origin;
			world_struct.modeldata{model}.duration = [world_llh_struct.modeldata{model}.data.duration];
			world_struct.modeldata{model}.duration = world_struct.modeldata{model}.duration(index_sort);
			if (full_info_flag)
				world_struct.modeldata{model}.mlf_data=struct('start_vector',{world_llh_struct.modeldata{model}.data.start_vector}, 'end_time', {world_llh_struct.modeldata{model}.data.end_time}, 'phoneme_vector',{world_llh_struct.modeldata{model}.data.phoneme_vector});
				world_struct.modeldata{model}.mlf_data=world_struct.modeldata{model}.mlf_data(index_sort);
			end	
	
		end

		if (~ cross_validation_flag ),
			world_temp_score_array =[];
			world_temp_rec_cell = {};
			world_temp_mlf_data = [];
			world_temp_durations = [];
			for index_impSpeaker = 1:length(world_llh_struct.impdata)
				if (strcmp(score_type,'simple sum')),
					world_temp_score_array = [world_llh_struct.impdata{index_impSpeaker}.data.simple_llh_sum];
				end
				if (strcmp(score_type,'per frame')),
					world_temp_score_array = [world_llh_struct.impdata{index_impSpeaker}.data.llh_per_frame];
				end
				world_temp_rec_cell = {world_llh_struct.impdata{index_impSpeaker}.data.file};
				world_temp_durations = [world_llh_struct.impdata{index_impSpeaker}.data.duration];
				if (isfield(world_llh_struct.impdata{index_impSpeaker}.data, 'start_vector'))
						world_temp_mlf_data = struct('start_vector',{world_llh_struct.impdata{index_impSpeaker}.data.start_vector}, 'end_time', {world_llh_struct.impdata{index_impSpeaker}.data.end_time}, 'phoneme_vector',{world_llh_struct.impdata{index_impSpeaker}.data.phoneme_vector});
				end				
				world_temp_rec_array=char(world_temp_rec_cell);
				[temp_struct, index_sort]=count_cdf_with_borders(world_temp_score_array,world_temp_rec_array);
				world_struct.impdata{index_impSpeaker}=temp_struct;
	
				world_struct.impdata{index_impSpeaker}.test_files_origin=world_llh_struct.impdata{index_impSpeaker}.test_files_origin;
				world_struct.impdata{index_impSpeaker}.duration=[world_temp_durations];
				world_struct.impdata{index_impSpeaker}.duration=world_struct.impdata{index_impSpeaker}.duration(index_sort);
				if (full_info_flag)
					world_struct.impdata{index_impSpeaker}.mlf_data=[world_temp_mlf_data];
					world_struct.impdata{index_impSpeaker}.mlf_data=world_struct.impdata{index_impSpeaker}.mlf_data(index_sort);
				end		
		
			
			end
		
		end
		
		%loeschen
		clear world_llh_struct;

	end

	
	result_struct.model_info.trained_models = trained_models;
	result_struct.model_info.trained_models_version = model_version;
	result_struct.model_info.training_session_details = training_session_details;

	result_struct.model_info.imp_tested_models = imp_tested_models;
	result_struct.model_info.imp_tested_models_version = imp_tested_model_version;
	result_struct.model_info.imp_test_spks = imp_test_spks;

	if (strcmp(norm_type,'cohort max') | strcmp(norm_type,'cohort mean')),
		result_struct.model_info.cohort_models = cohort_models;
		result_struct.model_info.cohort_model_version = cohort_model_version;
		result_struct.model_info.cohort_session_details = cohort_session_details;
	elseif (strcmp(norm_type,'simple world') | (incl_world_flag)),
		result_struct.model_info.world_tested_models = world_tested_models;
		result_struct.model_info.world_models = world_models;
		result_struct.model_info.world_model_version = world_model_version;
		result_struct.model_info.world_session_details = world_session_details;
	end

	result_struct.model_info.norm_type = norm_type;
	result_struct.model_info.llhsum_type = llhsum_type;
	result_struct.model_info.score_type = score_type;
	
	result_struct.model_info.paramPool_config = read_sv_system_paramPool_Info(sv_system_name);
	result_struct.model_info.sets = sets;
	result_struct.model_info.spk_struct_array = read_spk_info;
	
	result_struct.FR_struct = FR_struct;
	result_struct.FA_struct = FA_struct;
	if (incl_world_flag),
		result_struct.worlddata = world_struct;
	end
	result_struct.exp_name = sv_system_name;
	result_struct.result_name = result_name;
	result_struct.full_name = [sv_system_name '-' result_name];
	
	result_struct.cross_validation_flag = cross_validation_flag;
	


