function create_paramPool(pool_name, file_pattern_cell)
% function create_paramPool(pool_name, file_pattern_cell)
%
%  e.g. file_pattern_cell={'P1','P2','P3'}
%
% CVS_Version_String = '$Id: create_paramPool.m,v 1.10 2004/03/30 10:06:29 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


SR_lib;



for i=1:length(file_pattern_cell),
	file_pattern_cell{i} = [ '*' file_pattern_cell{i} '.' audio_file_ext];
end

pool_dir = [poolpath pool_name filesep];

cd(pool_dir);

configFullPath = [pool_dir 'configs' filesep 'C_' pool_name];


pool_config = read_paramPool_config(configFullPath);

% all spks
ds=dir([pool_dir '0*']);
for i=1:length(ds),
	spk_list{i} =  ds(i).name;
end
spk_list=sort(spk_list);

sessions_list = {sessions_lists{1}.item{:} sessions_lists{2}.item{:} sessions_lists{3}.item{:} sessions_lists{4}.item{:}}; % all sessions

for current_spk=1:length(spk_list),
	status=mkdir(spk_list{current_spk});
	cd(spk_list{current_spk});
	disp(['Current speaker: ' spk_list{current_spk}]);
		for current_session = 1:length(sessions_list),
			status=mkdir(sessions_list{current_session});
			cd(sessions_list{current_session});
			disp(['  Current session: ' sessions_list{current_session}]);
			dirstruct = dir_with_pattern_cell( fullfile(rawdatapath, spk_list{current_spk}, sessions_list{current_session}), file_pattern_cell );
			for filecounter = 1:length(dirstruct),
				if (str2num(dirstruct(filecounter).name(8)) <= 7),
					rawfilename = fullfile(rawdatapath, spk_list{current_spk}, sessions_list{current_session}, dirstruct(filecounter).name);
					disp(['    Current recording: ' dirstruct(filecounter).name(1:8)]);
					coeff_array = HTK_CreateParam(rawfilename,'raw',pool_config.targetKind, pool_config);
					writehtk([dirstruct(filecounter).name(1:8) '.param'], coeff_array',(pool_config.targetRate / 1e7),9);
				end
			end
			clear HTK_CreateParam;
			cd ..
		end
		
	cd ..

end
