function [it, param] = get_parameter_vs_it ( the_path, pattern, parameter )
% function [it, param] = get_parameter_vs_it ( the_path, pattern, parameter )
%
% e.g. [it, param] = get_parameter_vs_it( pwd, 'SVS_1-GMM*altTraining1*score.mat',
%                    'sr.part{1}.parameters.eer_mean')
%
% CVS_Version_String = '$Id: get_parameter_vs_it.m,v 1.2 2004/04/08 09:19:23 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	function_string = ['ret(i)=struct(''file'',result_name, ''data'', ' parameter ');'];
	ret = batch_process_results( the_path, pattern, function_string, 0);
	if (isempty(ret)),
		error('Nothing found! Check pattern and path!');
	end
	
	star_index = findstr('*',pattern);
	pattern1 = pattern(1:star_index(1) - 1);
	if (length(star_index) > 1),
		pattern2 = pattern(star_index(1) + 1:star_index(2)-1);
	else
		pattern2 = pattern(star_index(1) + 1:end);
	end
	
	for i=1:length(ret),
		
		start1 = findstr(pattern1, ret(i).file) + length(pattern1) - 1;
		remain = ret(i).file(start1(1) + 1:end);
		start2 = findstr(pattern2, remain) + start1(1) + length(pattern1) - 1;
		test_part = ret(i).file(start1(1):start2(1)-1);
		it_num(i) = extract_numbers(test_part);
	end
	[it, sorted_indizes] = sort(it_num);
	
	for i=1:length(sorted_indizes),
		param(i) = ret(sorted_indizes(i)).data;
	end
	
	return;
	
	
	function num = extract_numbers( string )
		num_indizes = find( (string >= '0') & (string <= '9') );
		num = str2num( string(num_indizes) );
	return;