function plot_world_llh_vs_it ( llh_struct )
	

	figure;
	hold on;

	colormap(hsv);
	m=colormap;
	for i=1:32,
		mycolors(i,:)=m(2*i,:);
	end
	
	mystyles={'-*', '-o','-x', '-s','-d'};
	
	legend_strings = {};
	for i=1:length( llh_struct.data ),
		plot( llh_struct.data(i).llh_values, mystyles{ mod(i, length(mystyles)) + 1}, 'Color', mycolors(i,:) );
		legend_strings{ end + 1 } = llh_struct.data(i).feature_type;
	end	
	lh=legend( legend_strings);
	sh=findobj(lh, 'type', 'text');
	set(sh, 'interpreter', 'none');
return