#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: check_MASV_experiment.pl,v 1.4 2004/05/04 09:06:30 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Cwd;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $exit_state = 0;

my ($minVar, $makeCohortNorm, $num_iterations_world, $num_iterations_model, $hmm_list, $dict,
	$doHNorm, $useHEAdapt, @teeModels, $numbernetWorldTest, $mlf_training, $mlf_test, @trainingModelConf,
	@HViteTrainedModelConf, @HViteWorldConf, @HViteCrossTestConf, $seed_world, $seed_models,
	@world_list, @world_test_list, $protoDir, @hmmBaseDirWorld, @hmmBaseDirModel,
	$hmm_version_model_test, $hmm_version_world_test, $hmm_version_cohort_test,
	$parallelComputation, $createdScript, $FA_id, $startMatlab, $pathMatlabResults,
	$autoClean_FA_Files, $useGMM, $mixtures, $doTestsOnly);

###########################
# Default values for options
my $help = 0;
my $Identify = 0;


$makeCohortNorm=0;
$hmm_list = "";
$dict = "";
$numbernetWorldTest = "";
$mlf_training = "";
$mlf_test = "";
@trainingModelConf = "";
@HViteTrainedModelConf = "";
@HViteWorldConf = "";
@HViteCrossTestConf = "";
$seed_world = "";
$seed_models = "";
@world_list = "";
@world_test_list = "";
$protoDir = "";
@hmmBaseDirWorld = "";
@hmmBaseDirModel = "";
$hmm_version_model_test = "";
$hmm_version_world_test = "";
$hmm_version_cohort_test = "";
$parallelComputation = 0;
$FA_id = "";
$doTestsOnly = 0;
$startMatlab = 0;




###########################
# Processing Options

# flat
GetOptions('help|?' => \$help,
		   'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 2) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $expConfig = $ARGV[0];
my $sv_system_name = $ARGV[1];

&SR_lib::init_speaker_sets($sv_system_name);


my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";
my $log_path = "${sv_system_path}log$SR_lib::sign";
my $experimentConfig_path = "${sv_system_path}expConfigs${SR_lib::sign}";


unless (open(CONFFILE, "${experimentConfig_path}$expConfig") ) {
	die "experiment config file $expConfig not found!\n\n";
}
my @confContent = <CONFFILE>;
close CONFFILE;

foreach (@confContent) {
	eval($_);
	unless ($@ eq "") {
		die "error in config file $expConfig :\nline $_ \nerror: $@ \n\n";
	}
}



@trainingModelConf = split(',',join(',',@trainingModelConf));
@HViteTrainedModelConf = split(',',join(',',@HViteTrainedModelConf));
@HViteWorldConf = split(',',join(',',@HViteWorldConf));
@HViteCrossTestConf = split(',',join(',',@HViteCrossTestConf));
@world_list = split(',',join(',',@world_list));
@world_test_list = split(',',join(',',@world_test_list));
@hmmBaseDirWorld = split(',',join(',',@hmmBaseDirWorld));
@hmmBaseDirModel = split(',',join(',',@hmmBaseDirModel));

if (!($doTestsOnly )) {
	if( !((scalar(@trainingModelConf) == scalar(@HViteTrainedModelConf)) &&
		(scalar(@trainingModelConf) == scalar(@HViteCrossTestConf)) &&
		(scalar(@HViteWorldConf) == scalar(@world_list)) &&
		(scalar(@HViteWorldConf) == scalar(@world_test_list)) &&
		(scalar(@HViteWorldConf) == scalar(@hmmBaseDirWorld)) &&
		(scalar(@trainingModelConf) == scalar(@hmmBaseDirModel)) )) 
	{
		print STDERR 'scalar(@trainingModelConf) ' . scalar(@trainingModelConf) . "\n";
		print STDERR 'scalar(@HViteTrainedModelConf) ' . scalar(@HViteTrainedModelConf) . "\n";
		print STDERR 'scalar(@HViteCrossTestConf) ' . scalar(@HViteCrossTestConf) . "\n";
		print STDERR 'scalar(@HViteWorldConf) ' . scalar(@HViteWorldConf) . "\n";
		print STDERR 'scalar(@world_list) ' . scalar(@world_list) . "\n";
		print STDERR 'scalar(@world_test_list) ' . scalar(@world_test_list) . "\n";
		print STDERR 'scalar(@hmmBaseDirWorld) ' . scalar(@hmmBaseDirWorld) . "\n";
		print STDERR 'scalar(@trainingModelConf) ' . scalar(@trainingModelConf) . "\n";
		print STDERR 'scalar(@hmmBaseDirModel) ' . scalar(@hmmBaseDirModel) . "\n";
		
		die "Length of comma separated lists must be eqal!\n";
	}
}
else {
	if( !((scalar(@HViteTrainedModelConf) == scalar(@HViteCrossTestConf)) &&
		(scalar(@HViteWorldConf) == scalar(@hmmBaseDirWorld)) &&
		(scalar(@HViteTrainedModelConf) == scalar(@hmmBaseDirModel)) )) 
	{
		print STDERR 'scalar(@HViteTrainedModelConf) ' . scalar(@HViteTrainedModelConf) . "\n";
		print STDERR 'scalar(@HViteCrossTestConf) ' . scalar(@HViteCrossTestConf) . "\n";
		print STDERR 'scalar(@hmmBaseDirModel) ' . scalar(@hmmBaseDirModel) . "\n";
		print STDERR 'scalar(@HViteWorldConf) ' . scalar(@HViteWorldConf) . "\n";
		print STDERR 'scalar(@hmmBaseDirWorld) ' . scalar(@hmmBaseDirWorld) . "\n";
		die "Length of comma separated lists must be eqal!\n";
	}
}

my $numSplitsModel = scalar(@HViteTrainedModelConf) - 1;
my $numSplitsWorld = scalar(@HViteWorldConf) - 1;

if ($FA_id eq "") {
	if ($numSplitsModel == 1) {
		$FA_id = $hmmBaseDirModel[0];
	}
	else {
		die "please set a file id (option id|FA_id)\n";
	}
}


if (($makeCohortNorm) && ($hmm_version_cohort_test eq "")) {
	die "Version of cohort model not set!\n";
}




&SR_lib::check_and_create_dir($log_path);

my $log_handle = &SR_lib::open_file(">", "$log_path" . "check_experiment_${FA_id}.log");

print $log_handle "\n\n";
print $log_handle scalar localtime, "\n";
print $log_handle "Running check_MASV_experiment.pl .....\n";
print $log_handle "---------------------------------------\n";
print $log_handle "Parameters:\n";
print $log_handle "sv_system             : $sv_system_path\n";
print $log_handle "Options:\n";
print $log_handle "mlf_training           : $mlf_training\n";
print $log_handle "mlf_test               : $mlf_test\n";
print $log_handle "hmm_list               : $hmm_list\n";
print $log_handle "makeCohortNorm         : $makeCohortNorm\n";
print $log_handle "trainingModelConf      : @trainingModelConf\n";
print $log_handle "HViteTrainedModelConf  : @HViteTrainedModelConf\n";
print $log_handle "HViteCrossConf         : @HViteCrossTestConf\n";
print $log_handle "HViteWorldConf         : @HViteWorldConf\n";
print $log_handle "seed_world             : $seed_world\n";
print $log_handle "seed_models            : $seed_models\n";
print $log_handle "world_list             : @world_list\n";
print $log_handle "world_test_list        : @world_test_list\n";
print $log_handle "numbernetWorldTest     : $numbernetWorldTest\n";
print $log_handle "protoDir               : $protoDir\n";
print $log_handle "hmmBaseDirWorld        : @hmmBaseDirWorld\n";
print $log_handle "hmmBaseDirModel        : @hmmBaseDirModel\n";
print $log_handle "hmm_version_model_test : $hmm_version_model_test\n";
print $log_handle "hmm_version_world_test : $hmm_version_world_test\n";
print $log_handle "hmm_version_cohort_test: $hmm_version_cohort_test\n";
print $log_handle "FA_id                  : $FA_id\n";
print $log_handle "doTestsOnly            : $doTestsOnly\n";
print $log_handle "startMatlab            : $startMatlab\n";




#####

my $temp_dir = cwd;

chdir $sv_system_path;


die "hmm list  $hmm_list not found!\n" if !(-e "../../hmm_lists/$hmm_list");
die "mlf for test $mlf_test not found!\n" if !(-e $mlf_test);
die "prototype directory $protoDir not found!\n" if !(-e $protoDir);
die "dictionary  $dict not found!\n" if !(-e "../../syntax/$dict");


if ($doTestsOnly) {
	for(my $index=0; $index<=$numSplitsWorld; $index++) {
		die "HMM base dir for world model $hmmBaseDirWorld[$index] not found!\n" if !(-d "world/$hmmBaseDirWorld[$index]");
	}

	for(my $index=0; $index<=$numSplitsModel; $index++) {
		my ($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteTrainedModelConf[$index]);
		my @spk_dirs = @{$theModelArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "HMM base dir of speaker model $hmmBaseDirModel[$index] not found!\n" if !(-d "${spk_dir}/$hmmBaseDirModel[$index]");
		}
	}

	print "OK\n";

}
else {
	
	################
	## test world ##
	################
	print "testing world model lists...\n";
	
	if ($seed_world) {
		die "seed world $seed_world not found!\n" if !(-d $seed_world);
	}
	die "mlf for training $mlf_training not found!\n" if !(-e $mlf_training);
	die "wordnet for world test $numbernetWorldTest not found!\n" if !(-e "../../syntax/$numbernetWorldTest");
	
	for(my $index=0; $index<=$numSplitsWorld; $index++) {

		my (@spk_dirs, $theWorldArrRef, $theSessions, $theWorldTestArrRef, $theModelArrRef);
		($theWorldArrRef, $theSessions)  =  &SR_lib::processConfigurations($world_list[$index]);
		@spk_dirs = @{$theWorldArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "S_list $theSessions for world spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
			&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
		}

		if ($hmm_version_world_test eq "") {
			($theWorldTestArrRef, $theSessions)  =  &SR_lib::processConfigurations($world_test_list[$index]);
			@spk_dirs = @{$theWorldTestArrRef};
			foreach my $spk_dir (@spk_dirs) {
				die "S_list $theSessions for world test spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
				&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
			}
		}
		($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteWorldConf[$index]);
		@spk_dirs = @{$theModelArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "HVite world test list $theSessions for spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
			&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
		}
	}
	
	######
	
	
	print "OK\n";
	
	
	print "testing model lists...\n";
	###############
	# test models #
	###############

	if (($seed_models) && ($seed_models ne "bestWorld") ) {
		die "seed for models $seed_models not found!\n" if !(-d $seed_models);
	}
	
	for(my $index=0; $index<=$numSplitsModel; $index++) {
		my ($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($trainingModelConf[$index]);
		my @spk_dirs = @{$theModelArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "training list  $theSessions for model spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
			&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
		}
	
	}
	
	
	#####
	
	
	if ($makeCohortNorm) {
		for(my $index=0; $index<=$numSplitsModel; $index++) {
			my ($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations("world_set/aa");
			my @spk_dirs = @{$theModelArrRef};
			foreach my $spk_dir (@spk_dirs) {
				die "training list $theSessions for cohort model spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
				&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
			}
		
		}
	}
	
	for(my $index=0; $index<=$numSplitsModel; $index++) {
		my ($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteTrainedModelConf[$index]);
		my @spk_dirs = @{$theModelArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "test list $theSessions for model spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
			&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
		}
	
	}
	
	print "OK\n";
	
	
	print "testing impostor lists...\n";
	
	for(my $index=0; $index<=$numSplitsModel; $index++) {
		my ($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteCrossTestConf[$index]);
		my @spk_dirs = @{$theModelArrRef};
		foreach my $spk_dir (@spk_dirs) {
			die "test list $theSessions for imp spk $spk_dir not found!\n" if !(-e "${spk_dir}/$theSessions");
			&check_S_list_consistency("${spk_dir}/$theSessions", $sv_system_name);
		}
	
	}
	
	print "OK\n";

}	
#####


close $log_handle;

chdir $temp_dir;
	
exit 0;


sub check_S_list_consistency {
	
	my $file_path_rel = $_[0];
	my $sv_system_name = $_[1];
	
	my $file_handle = &SR_lib::open_file("<", "$file_path_rel");
	my @file_content = <$file_handle>;
	close $file_handle;
	
	foreach (@file_content) {
		if ($_ !~ /\/$sv_system_name\//) {
			print STDERR "Warning: File $file_path_rel contains a path for a different sv_system! Are you sure?\n";
			last;
		}
	}
}


__END__

=head1 NAME

check_MASV_experiment.pl  - check files for an experiment

=head1 SYNOPSIS

check_MASV_experiment.pl [options] expConfig sv_system_name

Check the given experiment configuration "expConfig" of  the SV system
<sv_system_name> for completeness of the 
list files and of the configuration files. The path to the file "expConfig" 
is given relative to the directory "expConfig/" of the SV system.

 Options:

 -version                 print version information.

 -? | help                display this message.
 
=cut

