#!/bin/bash

# #####################################################
#
# This file is part of the shell scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

# '$Id: cp_experiment_data.sh,v 1.7 2004/03/31 13:51:58 tuerk Exp $';
# '$Name: rel-1-4-01 $';

sv_system_name=$1
mlf_name=$2
target_dir=$3

sv_system_dir=${MASV_BASEDIR}sv_systems/${sv_system_name}/ 
dest_dir=${target_dir}sv_systems/${sv_system_name}/

rm -rf $dest_dir || exit 1
mkdir -p $dest_dir || exit 1

cp -r ${sv_system_dir}links $dest_dir  || exit 1
cp -r ${sv_system_dir}info $dest_dir  || exit 1
mkdir ${dest_dir}tmp  || exit 1


cd ${sv_system_dir}  || exit 1

find . -name "*${mlf_name}*" > listing_for_cp_exp_data  || exit 1
find . -name 'S_list*' >> listing_for_cp_exp_data  || exit 1

tar czf for_cp_exp_data.tgz -T listing_for_cp_exp_data   || exit 1
cp for_cp_exp_data.tgz $dest_dir || exit 1

rm for_cp_exp_data.tgz  || exit 1

cd $dest_dir  || exit 1

tar xzf for_cp_exp_data.tgz  || exit 1

exit 0;


