#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: enable_hmm_for_HEAdapt.pl,v 1.5 2004/02/17 15:36:39 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $help = 0;
my $Identify = 0;
my $trainingModelConf = "all_training/fa";

GetOptions('help|?' => \$help,
	       'tc|trainingModelConf=s' => \$trainingModelConf,
			'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}


if ((@ARGV != 3) || ($help)) {
   pod2usage(1);
   exit 1;
 }
 

my $sv_system_name = $ARGV[0];
my $hmm_name = $ARGV[1];
my $hmm_type = $ARGV[2];

die "Use \"world\" or \"model\" as type parameter!\n" if ( ($hmm_type ne "world") && ($hmm_type ne "model"));

&SR_lib::init_speaker_sets($sv_system_name);

my $g_vecsize;
my $g_streaminfo;
my $g_mixcounter = 0;

if ($hmm_type eq "world") {
	my $hmm_dir_full_path = "${SR_lib::sv_systems_dir}${sv_system_name}/world/${hmm_name}/hmm.0";
	
	opendir SRCDIR, $hmm_dir_full_path;
	my @hmms = grep(!/^\./, readdir(SRCDIR)); #Forget about . files
	closedir SRCDIR;

	&process_hmms(\@hmms, $hmm_dir_full_path);
	&write_global_macro("${SR_lib::sv_systems_dir}${sv_system_name}/world/${hmm_name}/HEAdpat_dummy.mmf");
}
else {
	my ($trainingModelArrRef, $trainingModelSessionsList) =  &SR_lib::processConfigurations($trainingModelConf);
	my @models = @{$trainingModelArrRef};
	foreach my $model (@models) {
		$g_mixcounter = 0;
		my $hmm_dir_full_path = "${SR_lib::sv_systems_dir}${sv_system_name}/$model/${hmm_name}/hmm.0";
	
		opendir SRCDIR, $hmm_dir_full_path;
		my @hmms = grep(!/^\./, readdir(SRCDIR)); #Forget about . files
		closedir SRCDIR;

		&process_hmms(\@hmms, $hmm_dir_full_path);
		&write_global_macro("${SR_lib::sv_systems_dir}${sv_system_name}/$model/${hmm_name}/HEAdapt_dummy.mmf");

	}
}




exit 0;

sub write_global_macro {
	my $full_filename = $_[0];
	
	my $file_handle = &SR_lib::open_file(">", "$full_filename");
	print $file_handle "~o\n";
	print $file_handle "<HMMSETID> dummyid\n";
	print $file_handle "$g_streaminfo";
	print $file_handle "$g_vecsize";
	print $file_handle "~r \"rtree_1\"\n";
	print $file_handle "<REGTREE> 1\n";
	print $file_handle "<TNODE> 1 $g_mixcounter\n";
	close $file_handle;
	
}


sub process_hmms {
	my $hmms_ref = $_[0];
	my $path = $_[1];
	foreach my $file (@{$hmms_ref}) {
		my $file_handle = &SR_lib::open_file("<", "${path}/${file}");
		my @file_content = <$file_handle>;
		close $file_handle;
				
		
		my $uses_mixtures = 0;
		my $rclass_already_applied = 0;
		foreach my $line (@file_content) {
			if ($line =~ /<VECSIZE>/i) {
				$g_vecsize = $line;
			}
			if ($line =~ /<STREAMINFO>/i) {
				$g_streaminfo = $line;
			}
			
			if ($line =~ /<MIXTURE>/i) {
				$uses_mixtures = 1;
				last;
			}
			if ($line =~ /<RCLASS>/i) {
				$rclass_already_applied = 1;
				last;
			}
		}
		
		
		# write new version
		my $file_handle = &SR_lib::open_file(">", "${path}/${file}");

		if ($uses_mixtures) {
			
			foreach my $line (@file_content) {
				print $file_handle "$line";
				if ($line =~ /<MIXTURE>/i) {
					if (! $rclass_already_applied) {
						print $file_handle "<RCLASS> 1\n";
					}
					$g_mixcounter++;
				}
			}
			
		}
		else {
			foreach my $line (@file_content) {
				print $file_handle "$line";
				if ($line =~ /<STATE>/i) {
					if (! $rclass_already_applied) {
						print $file_handle "<RCLASS> 1\n";
					}
					$g_mixcounter++;
				}
			}
		}

		close $file_handle;
		
	}
	
}


__END__

=head1 NAME

enable_hmm_for_HEAdapt.pl  - supplies macro file and performs hmm 
                               modifications in order to use HEAdapt 
                               during training.

=head1 SYNOPSIS

enable_hmm_for_HEAdapt.pl sv_system_name hmm_name hmm_type

  hmm_type: "world" or "model"

 Options:
 
 -tc | trainingModelConf   use given model_dirs from conf.; 
                           default is 'all_training/aa'
                           see sub processConfigurations in SR_lib.pm
                           ignored, when hmm_type is "world".

=cut

