
/**************************************************************************
***************************************************************************

Modul           : vekmath.c
Titel           : mathematische funktionen fuer vektoren und arrays
Autor           : F. Schiel
Datum/Aenderung : 10.08.90 / 30.08.91

Beschreibung:
allgemeine funktionen zur behandlung von mehrdimensionalen feldern.

namensgebung:   operand1_operator_operand2
operand:	z.B. float = einfacher float-wert
		     float2 = 2-dim. float-feld
		     short1 = 1-dim. short-vektor
operator:	z.B. add = addition
		     mult = multiplikation

Anzulinkende Module	:

Subroutinen:
reset_float2		: alle elemente eines 2-dim. float-feldes 0 setzten
reset_int2		: alle elemente eines 2-dim. int-feldes 0 setzen
float2_add_float2	: addition zweier 2-dim. float-felder
float2_sub_float2  	: subtraktion zweier 2-dim. float-felder
float2_div_float  	: 2-dim. float-feld durch float-konstante teilen
float2_div_int1		: zeilen von 2-dim. float-feld durch int-vektor
betrag_float		: betrag eines float-vektors bilden
recmittel_float		: rekursive mittelwertbildung von float-vektoren
max_float2		: max. wert eines 2-dim. float-feldes
min_float2		: min. wert eines 2-dim. float-feldes
norm_float2		: 2-dim. float-feld auf geg. wert normieren 

*/
# include <math.h>
# include <stdio.h>
# include "ipkclib.h"

/* DEFINES, die nur innerhalb dieses Moduls Verwendung finden ***********/
# define MAXFLOAT 1.7E+38
# define MINFLOAT -1.7E+38

/* TYPDEFINITONEN von Typen, die nur innerhalb dieses Moduls vorkommen **/


/* GLOBALE VARIABLEN, dieses Moduls *************************************/


/* FUNKTIONSPROTOTYPEN, die ausserhalb dieses Moduls unbekannt sind *****/


/*----------------------------------------------------------------------

Name            : reset_float2
Modul           : vekmath.c
Titel           : alle elemente eines 2-dim. float-feldes 0 setzten

Beschreibung:
setzt alle elemente eines 2-dim. float-feldes zu null		

Parameter:
feld		: 2-dimensionales float-feld
		  (1-dim.: dim1=1 !)

Return-Value	: void
*/
void reset_float2(float *feld,int dim1,int dim2)

{
	int l,i;

	for(l=0 ;l<dim1 ;l++)
		for(i=0; i<dim2; i++) *(feld++) = 0.;
}
/* ende von routine reset_float2					*/


/*------------------------------------------------------------------------

Name            : reset_int2
Modul           : vekmath.c
Titel           : alle elemente eines 2-dim. int-feldes 0 setzten

Beschreibung:
setzt alle elemente eines 2-dim. int-feldes zu null		

Parameter:
feld		: 2-dimensionales int-feld
		  (1-dim.: dim1=1 !)

Return-Value	: void
*/
void reset_int2(int *feld,int dim1,int dim2)

{
	int l,i;

	for(l=0 ;l<dim1 ;l++)
		for(i=0; i<dim2; i++) *(feld++) = 0;
}
/* ende von routine reset_int2					*/


/*-----------------------------------------------------------------------

Name            : float2_add_float2
Modul           : vekmath.c
Titel           : addition zweier 2-dim. float-felder

Beschreibung:
addition der elemente zweier 2-dim. float-felder : sum1 + sum2 = sum

Parameter:
sum, sum1, sum2	: pointer auf 1 oder 2-dim. float-feld
dim1		: zeilen
dim2		: spalten

Return-Value	: void
*/
void float2_add_float2(float *sum1,float *sum2,float *sum,int dim1,int dim2)

{
	int i,j;

	for(i=0; i<dim1; i++)
		for(j=0; j<dim2; j++) *(sum++) = *(sum1++) + *(sum2++);
}
		

/*-----------------------------------------------------------------------

Name            : float2_sub_float2
Modul           : vekmath.c
Titel           : subtraktion zweier 2-dim. float-felder

Beschreibung:
subtrahiert ein array sub2 vom array sub1 und legt ergebnis nach erg
alle arrays mit dimensionen  dim1 und dim2: vek[dim1][dim2]

Parameter:
erg,sub1,sub2	: pointer auf 1 oder 2-dim. float-feld
dim1		: zeilen
dim2		: spalten

Return-Value	: void
*/
void float2_sub_float2(float *sub1,float *sub2,float *erg,int dim1,int dim2)

{
	int i,j;

	for(i=0; i<dim1; i++)
	    for(j=0; j<dim2; j++)
		*(erg++) = *(sub1++) - *(sub2++);
}

/*-------------------------------------------------------------------------

Name            : float2_div_float
Modul           : vekmath.c
Titel           : 2-dim. float-feld durch float-konstante teilen

Beschreibung:
division eines 2-dim. float-feldes durch float-konstante.

Parameter:
divisor		: pointer auf 1 oder 2-dim. float-feld, divisor
dividend	: float-wert, dividend
div		: pointer aus 1 oder 2-dim. float-feld, ergebnis
dim1		: zeilen
dim2		: spalten

Return-Value	: void
*/
void float2_div_float(float *divisor,float dividend,
			float *div,int dim1,int dim2)

{
	int i,j;

	if(dividend == 0) 
	{	
		printf("feld2_div_sing: division by zero !\n");
		exit();
	}
	for(i=0; i<dim1; i++)
		for(j=0; j<dim2; j++) *(div++) = *(divisor++) / dividend;
}

/*----------------------------------------------------------------------

Name            : float2_div_int1
Modul           : vekmath.c
Titel           : zeilen von 2-dim. float-feld durch int-vektor

Beschreibung:
division der zeilen eines 2-dim. feldes durch einen 1-dim vektor.
division durch null erzeugt abbruchfehler.

Parameter:
divisor		: pointer auf 1 oder 2-dim. float-feld, divisor
dividend	: pointer auf 1-dim. integer-feld, dividend
div		: pointer aus 1 oder 2-dim. float-feld, ergebnis
dim1		: zeilen
dim2		: spalten

Return-Value	: void
*/
void float2_div_int1(float *divisor,int *dividend,float *div,
	int dim1,int dim2)

{
	int	i,j;

	for(i=0; i<dim1; i++)
	{
		switch(*dividend)
		{	
		case 0 : printf("feld2_div_feld1: division by zero !\n");
			 exit();
		case 1 : for(j=0; j<dim2; j++)
				*(div++) = *(divisor++);
			 break;
		default : for(j=0; j<dim2; j++)
				*(div++) = *(divisor++) / *dividend;
		}
		dividend++;
	}
} /* ende subroutine float2_div_int1 */

/*----------------------------------------------------------------------

Name		: betrag_float
Modul		: vekmath
Titel		: betrag eines float-vektors bilden

Beschreibung:
berechnet die laenge (betrag des uebergebenen float-vektors der dimension 
dim:
	betrag = SQRT(x1^2 + x2^2 + ... +xn^2)

Parameter:
vektor		: vektor von floatwerten 
dim		: dimension des vektors

Return-Value	: laenge des vektors (betrag)
----------------------------------------------------------------------*/
double betrag_float(float *vektor,int dim)
{
	register int	i;
	double		betrag;

    betrag = 0.;
    for(i=0; i<dim; i++)
    {
	betrag += *vektor * *vektor;
	vektor++;
    }
    return(sqrt(betrag));

} /* ende subroutine betrag_float					*/

/*----------------------------------------------------------------------

Name		: recmittel_float
Modul		: vekmath
Titel		: rekursive mittelwertbildung von float-vektoren

Beschreibung:
mittelt den uebergebenen vektor rekursiv auf den mittelwertsvektor mittel,
auf den bereits c vektoren vorher gemittelt wurden:

	mittel(neu) = (1 - 1/(c+1)) mittel(alt) + 1/(c+1) vektor

c wird um 1 erhoeht und als returnwert zurueckgegeben (zaehlerstand). 
der neue mittelwert ueberschreibt den alten mittelwert mittel.

Parameter:
dim		: dimension der vektoren
mittel		: pointer auf alten und neuen mittelwertsvektor
c		: anzahl der auf den alten mittelwertsvektor bereits 
		  gemittelten vektoren
vektor		: neuer datenvektor, der zum mittelwert beitragen soll

Return-Value	: neuer zaehlerstand c + 1

----------------------------------------------------------------------*/
int recmittel_float(int dim,float *mittel,int c,float *vektor)
{
	int	i,j;

    c++;
    for(i=0; i<dim; i++)
	mittel[i] = (1. - 1/(float)c) * mittel[i]  +  vektor[i] / c ;

    return(c);

} /* ende subroutine recmittel_float					*/


/*----------------------------------------------------------------------

Name		: max_float2		
Modul		: vekmath
Titel		: max. wert eines 2-dim. float-feldes

Beschreibung:
liefert das element des uebergebenen float-feldes mit maximalem wert

Parameter:
feld		: pointer auf 2-dim. array von float-werten 
dim1		: zeilen
dim2		: spalten

Return-Value	: max. wert
----------------------------------------------------------------------*/
float max_float2(float *feld,int dim1,int dim2)
{
	int	i,j;
	float max = MINFLOAT;

    for(i=0;i<dim1;i++)
	for(j=0;j<dim2;j++)
	    if(*(feld++) > max) max = *(feld-1); 
    return(max);
}

/*----------------------------------------------------------------------

Name		: min_float2		
Modul		: vekmath
Titel		: min. wert eines 2-dim. float-feldes

Beschreibung:
liefert das element des uebergebenen float-feldes mit minimalem wert

Parameter:
feld		: pointer auf 2-dim. array von float-werten 
dim1		: zeilen
dim2		: spalten

Return-Value	: min. wert
----------------------------------------------------------------------*/
float min_float2(float *feld,int dim1,int dim2)
{
	int	i,j;
	float   min = MAXFLOAT;

    for(i=0;i<dim1;i++)
	for(j=0;j<dim2;j++)
	    if(*(feld++) < min) min = *(feld-1); 
    return(min);
}

/*----------------------------------------------------------------------

Name		: norm_float2
Modul		: vekmath
Titel		: 2-dim. float-feld auf geg. wert normieren

Beschreibung:
normiert werte eines 2-dim. float-feldes so, dass die summe aller 
enthaltenen werte dem uebergebenen float-wert entspricht. bei normierung 
1-dim felder ist erste dimension zu 1 zu setzen. 

Parameter:
feld		: pointer auf 2-dim. float-feld 
dim1		: spalten-dimension (bei 1-dim. feldern gleich 1)
dim2		: zeilen-dimension
norm		: normierungswert (summe aller werte nach durchfuehrung)

Return-Value	: void
----------------------------------------------------------------------*/
void norm_float2(float *feld,int dim1,int dim2,float norm)
{
	int	i,dim;

	float	summ = 0.,
		*hfeld;
    hfeld = feld;
    dim = dim1 * dim2;
    for(i=0; i<dim; i++)
	summ += *(hfeld++);
    norm /= summ;
    for(i=0; i<dim; i++)	
	*(feld++) *= norm;
}
