BEGIN   {
	  wrdcnt = 0
	  wrdidx = 0
	  segidx = 1
	  xmin = -1.0
	  # read in list of words from input BPF
	  while(getline <BPF > 0)
	  {
	    if($1 == ORTTYPE)
	    {
	      ort = $3
	      if ( NF > 3 ) {
	        # label consists of more than one element (e.g. KAN with LANGUAGE=sampa)
                for(i=4;i<=NF;i++) ort = ort " " $i 
	      }
	      if(ORTTYPE == "ORT:")
	      # handle LaTeX Umlauts which are not possible in TextGrid
	      {
	        gsub(/"a/,"ä",ort)
	        gsub(/"u/,"ü",ort)
	        gsub(/"o/,"ö",ort)
  	        gsub(/"A/,"Ä",ort)
	        gsub(/"U/,"Ü",ort)
	        gsub(/"O/,"Ö",ort)
	        gsub(/"s/,"ß",ort)
	      }
	      if(ORTTYPE == "KAN:")
	      # delete secondary lexical accent markers in transcript
	      {
	        gsub(/"/,"",ort)
	      }
	      ortarr[$2] = ort
	      wrdcnt ++
	      # print $2 " : " ortarr[$2]
	    }
	  }
	}  
	{
	  beginn = $2
	  dauer = $3
	  wordlink = $4

	  # it is possible that a phoneme is shared by two words:
	  # SAP: #### #### 10,11 m
	  # in this case we split the segment 50:50 and treat it as two 
	  # segments regarding the symbolic tier by first processing the 
	  # first wordlink and then process the second half as 'normal' segments
	  if(index(wordlink,",") != 0) {
	    # split phoneme
	    if(split($4,sarr,",") != 2) {
	      print "ERROR: symbolic link with more than two word references: " $4 > "/dev/stderr"
	      exit 1
	    }
	    wordlink = sarr[1]
	    dauer = dauer / 2.0
  	    # if xmin is set to -1.0 we are outside a word; so if the word index
  	    # turns to the right number and we are not already in that word
  	    # we enter the word now
  	    if ( xmin == -1.0 && wordlink >= wrdidx ) {
  	      xmin = beginn*1.0/SAMPLERATE
  	      xmax = (beginn+dauer+1)*1.0/SAMPLERATE   # half of segment!
              wrdidx = wordlink
  	    }
  	    # if we already are with a word (xmin != -1.0) then we look for 
  	    # the end; here this can be only the next word (> wrdidx)
  	    if ( xmin != -1.0 &&  wordlink > wrdidx ) {
	      # print the last word segment
  	      printf("        intervals [%d]:\n",segidx)
              printf("            xmin = %f\n",xmin)
              printf("            xmax = %f\n",beginn*1.0/SAMPLERATE)
              printf("            text = \"%s\"\n",ortarr[wrdidx])
  	      segidx ++
  	      # then we enter the next word
  	      xmin = beginn*1.0/SAMPLERATE
  	      wrdidx = wordlink
	    }  
            # now take the second half of the phoneme and link it to the second wordlink
	    # and proceed as if this is a 'normal' segment coming up
	    beginn = beginn + dauer
	    wordlink = sarr[2]
	    
	  }

	  # 'normal' case where only a single word is linked to the phoneme

  	  # if xmin is set to -1.0 we are outside a word; so if the word index
  	  # turns to a number equal or higher than the expected wrdidx 
          # (we are not already in that word and it's not another silence interval),
  	  # we enter the word now
  	  if ( xmin == -1.0 && wordlink >= wrdidx )
  	  {
  	    xmin = beginn*1.0/SAMPLERATE
  	    xmax = (beginn+dauer+1)*1.0/SAMPLERATE
            wrdidx = wordlink   # in case that we skipped a word which can happen!
  	  }
  	  # if we already are with a word (xmin != -1.0) then we look for 
  	  # the end; this can be either a silence interval (-1) or the 
  	  # next word (> wrdidx)
  	  if ( xmin != -1.0 && ( wordlink > wrdidx || wordlink == -1 ) )
  	  {
  	    printf("        intervals [%d]:\n",segidx)
              printf("            xmin = %f\n",xmin)
              printf("            xmax = %f\n",beginn*1.0/SAMPLERATE)
              printf("            text = \"%s\"\n",ortarr[wrdidx])
  	    segidx ++
  	    # if its a silence interval, we leave the word
  	    if ( wordlink == -1 )
  	    {
  	      xmin = -1.0
  	      wrdidx ++
  	    }
  	    else
  	    # we enter the next word
  	    {
  	      xmin = beginn*1.0/SAMPLERATE
  	      wrdidx = wordlink
  	    }  
  	  }
            # if segment is a silence interval create an interval with empty label 
  	  # in the word tier (since programs like Emu do not handle empty segments well)
  	  if ( wordlink == -1 )
  	  {
  	    printf("        intervals [%d]:\n",segidx)
              printf("            xmin = %f\n",beginn*1.0/SAMPLERATE)
              printf("            xmax = %f\n",(beginn+dauer+1)*1.0/SAMPLERATE)
              printf("            text = \"\"\n")
  	    segidx ++
	  }  
	}
END     {
          # print last word, if we are still within the last word
	  if ( xmin != -1.0 ) 
	  {
	    printf("        intervals [%d]:\n",segidx)
            printf("            xmin = %f\n",xmin)
            printf("            xmax = %f\n",(beginn+dauer+1)*1.0/SAMPLERATE)
            printf("            text = \"%s\"\n",ortarr[wrdidx])
	  }  
          #if ( wrdidx != wrdcnt ) printf("ERROR: number of words in %s (%d) differs from number of words in mau output (%d)\n",ORTTYPE,wrdcnt,wrdidx) > "/dev/stderr"
        }
