BEGIN { first_idx = EMUID 
        idx = EMUID }
{ 
  # this script gets filtered BPF class 4 tiers!
  if($4=="-1") {
    # free-floating segment : link to bundle
    ortidx[idx] = -1  # tier word link starts with 0!
  }
  else {
    # consistency check: if there is no class 1 tier, we can't have word links other than '-1'
    if(CLASS1LEVEL=="") {
      printf("ERROR: mausbpf2emuR : input BPF has no class 1 tier but a class 4 tier that links to it - exiting\n") > "/dev/stderr"
      exit(1)
    }
    ortidx[idx] = $4
  }
  idx ++
}
END {
  for(i=first_idx;i<idx;i++) {
    nc = split(ortidx[i],carr,/[,;]/)
    for(j=1;j<=nc;j++) {
      # BPF links start with 0, but class 1 level starts with 1!
      printf("        {\n            \"fromID\": %d,\n            \"toID\": %d\n        }",carr[j]+1,i)
      if( i<idx-1 || j<nc ) printf(",")
      printf("\n")
    }
  }
}
