
/***********************************************************************
************************************************************************

Modul		: strop
Titel		: String-Operationen

Autor		: F. Schiel, T. Schultz
Datum/Aenderung : 01.06.92 /

Beschreibung	: 
Enthaelt allgemeine String-Operatoren, d.h. Konvertierungen etc.

Anzulinkende Module (ausser SCHCLIB/LIB): <ctype>

Enthaltene Funktionen:
sam2vaxdname		: konversion SAM-Label in VAX/VMS-Dateiname 
			:

*************************************************************************/
# include <ctype.h>
# include "ipkclib.h"

/* # include "strop.h" */

/* DEFINES, die nur innerhalb dieses Moduls Verwendung finden ***********/


/* TYPDEFINITONEN von Typen, die nur innerhalb dieses Moduls vorkommen **/


/* GLOBALE VARIABLEN, dieses Moduls *************************************/


/* FUNKTIONSPROTOTYPEN, die ausserhalb dieses Moduls unbekannt sind *****/



/*------------------------	sam2vaxdname	--------------------------------------------

Name		: 	sam2vaxdname
Modul		:	strop
Titel		:	Konversion SAMPA-Label in VAX/VMS-Dateinname

Beschreibung:	konvertiert SAM-Labels nach VAX/VMS-Dateinamenkonvention
		ACHTUNG:	s  muss ausreichend Platz bieten, da Grossbuchstaben 
				jeweils mit  Z W E I  Zeichen dargestellt werden 
				"<Grossbuchstabe>"  -->>  "1<Grossbuchstabe>"	!!!!!
		ACHTUNG:	s  darf keine VAX/VMS-Plattenbezeichnung sein (':') !!

Parameter:	
s		: pointer auf SAM-Label und konvertiertes SAM-Label

Return-Value:	void
*/

void	sam2vaxdname (	char	*s	)
{
	/***	Ziffern, die NICHT im SAMPA-Inventar enthalten sind:
			1  3  4  5  7  8  0
	***/
	int	i;

	for (i = strlen( s ) - 1; i >= 0; --i)
		switch (s[ i ])  {
		case '/':	s[ i ] = '7';	/***	'7'  leere AKF	***/
				break;
		case '\\':	s[ i ] = '5';	/***	'5'  leeres Rudiment	***/
				break;
		case '@':	s[ i ] = '8';
				break;
		case ':':	s[ i ] = '3';
				break;
		case '.':	s[ i ] = '0';	/***	'0'  silbischer Konsonant	***/
				break;
		default:	/***	Grossbuchst. oder keine Umsetzung	***/
				if (isupper( s[ i ] ))
				{	/***	Grossbuchstabe	***/
					memmove( s+i+1,  s+i, strlen( s+i ) + 1 );	/***	"+1":  inclusive  '\0' !!	***/
					s[ i ] = '1';		/***	... das Einleitungszeichen fuer Grossbuchstaben	***/
				}
				/***	sonst:	keine Umsetzung	***/
		}
/*
printf( "vms-D.Name: >>%s<<\n", s );
*/
}
/**	ende: sam2vaxdname	**/
