#!/bin/csh

# general tool to make a rough consistency check about the 
# number of symbolic links in a partitur file
# the following is checked:
# - max. number match of symbolic links in TRL,KAN,ORT,DAS,SAP,MAU,
#   PRB,WOR,TR2,PRS,NOI,SYN,FUN,LEX,PRO,POS,LMA,TRN,TRS,USP,TLN,TRW,MAS
#   (class 2 and 3 tiers are not checked because they do not contain 
#    symbolic links)
# - if TR2 is present, checks whether SUP is present, too


# Partitur Version 1.2.16

# usage: chkpartitur file.par [file1.par ...]

#set verbose=0 

if ( $1 == "" ) then
  echo 'usage: chkpartitur.csh file.par [file.par...]'
  exit 1
endif

while ( $1 != "" )
  set file = $1
#  echo $file
  set kanflag = 0
  set trlflag = 0
  set tr2flag = 0
  set trwflag = 0
  set ortflag = 0
  set ptrflag = 0
  set sapflag = 0
  set mauflag = 0
  set masflag = 0
  set prbflag = 0
  set worflag = 0
  set dasflag = 0
  set noiflag = 0
  set prsflag = 0
  set proflag = 0
  set synflag = 0
  set funflag = 0
  set lexflag = 0
  set posflag = 0
  set lmaflag = 0
  set trnflag = 0
  set trsflag = 0
  set uspflag = 0
  set tlnflag = 0
  set kanlinks = 0
  set trllinks = 0
  set tr2links = 0
  set trwlinks = 0
  set ortlinks = 0
  set ptrlinks = 0
  set saplinks = 0
  set maulinks = 0
  set maslinks = 0
  set prblinks = 0
  set worlinks = 0
  set daslinks = 0
  set noilinks = 0
  set prslinks = 0
  set prolinks = 0
  set synlinks = 0
  set funlinks = 0
  set lexlinks = 0
  set poslinks = 0
  set lmalinks = 0
  set trnlinks = 0
  set trslinks = 0
  set usplinks = 0
  set tlnlinks = 0
  # try to get a reference tier
  if ( `grep -c '^KAN:' $file` > 0 ) then
    set kanflag = 1
    set kanlinks = `cat $file | grep '^KAN:' | awk 'BEGIN{link=-99} { if ($2 > link) link = $2 } END{print link}'`
  else
    echo WARNING: file $file contains no KAN reference tier - reference is checked to TRL tier
  endif
  if ( `grep -c '^TRL:' $file` > 0 ) then
    set trlflag = 1
    set trllinks = `cat $file | grep '^TRL:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $kanflag == 0 ) then
      set kanflag = 1
      set kanlinks = $trllinks
    endif
  else if ( kanflag == 0 ) then 
    echo WARNING: file $file contains no TRL reference tier - reference is checked to TR2 tier
  endif
  if ( `grep -c '^TR2:' $file` > 0 ) then
    set tr2flag = 1
    set tr2links = `cat $file | grep '^TR2:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $kanflag == 0 ) then
      set kanflag = 1
      set kanlinks = $tr2links
    endif
  else if ( kanflag == 0 ) then
    echo WARNING: file $file contains no TR2 reference tier - reference is checked to TRS tier
  endif
  if ( `grep -c '^TRS:' $file` > 0 ) then
    set trsflag = 1
    set trslinks = `cat $file | grep '^TRS:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $kanflag == 0 ) then
      set kanflag = 1
      set kanlinks = $trslinks
    endif
  else if ( kanflag == 0 ) then
    echo WARNING: file $file contains no TRS reference tier - reference is checked to ORT tier
  endif
  if ( `grep -c '^TRW:' $file` > 0 ) then
    set trwflag = 1
    set trwlinks = `cat $file | grep '^TRW:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $kanflag == 0 ) then
      set kanflag = 1
      set kanlinks = $trwlinks
    endif
  else if ( kanflag == 0 ) then
    echo WARNING: file $file contains no TRW reference tier - reference is checked to ORT tier
  endif
  if ( `grep -c '^ORT:' $file` > 0 ) then
    set ortflag = 1
    set ortlinks = `cat $file | grep '^ORT:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $kanflag == 0 ) then
      set kanflag = 1
      set kanlinks = $ortlinks
    endif
  endif
  
  if ( $kanflag == 0 ) then
    echo ERROR: cannot check, because no reference tier found in file $file
    shift
    continue
  endif

  # special tier combination checks
  if ( `grep -c '^TR2:' $file` > 0 ) then
    set tr2flag = 1
    set tr2links = `cat $file | grep '^TR2:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $tr2links == -1 ) then
      set tr2flag = 0
      echo WARNING TR2 contains only -1 links
    endif
    # if there is at least one '@' in the TR2 tier, there has to be a SUP
    # tier too
    set atcount = `cat $file | grep '^TR2:' | grep -c '@'`
    if ( `grep -c '^SUP:' $file` == 0 && $atcount > 0 ) then
      echo "WARNING: no SUP tier but TR2 with @ in file $file"
    endif
  endif
  
  # class 1 tier checks
  if ( `grep -c '^ORT:' $file` > 0 ) then
    set ortflag = 1
    set ortlinks = `cat $file | grep '^ORT:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $ortlinks == -1 ) then
      set ortflag = 0
      echo WARNING ORT contains only -1 links
    endif
  endif
  if ( `grep -c '^PTR:' $file` > 0 ) then
    set ptrflag = 1
    set ptrlinks = `cat $file | grep '^PTR:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $ptrlinks == -1 ) then
      set ptrflag = 0
      echo WARNING PTR contains only -1 links
    endif
  endif
  if ( `grep -c '^DAS:' $file` > 0 ) then
    set dasflag = 1
    set daslinks = `cat $file | grep '^DAS:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $daslinks == -1 ) then
      set dasflag = 0
      echo WARNING DAS contains only -1 links
    endif
  endif
  if ( `grep -c '^TLN:' $file` > 0 ) then
    set tlnflag = 1
    set tlnlinks = `cat $file | grep '^TLN:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $tlnlinks == -1 ) then
      set tlnflag = 0
      echo WARNING TLN contains only -1 links
    endif
  endif
  if ( `grep -c '^NOI:' $file` > 0 ) then
    set noiflag = 1
    set noilinks = `cat $file | grep '^NOI:' | awk 'BEGIN{link=-99} { if ( match($2,",") == 0 && match($2,";") == 0 ) { if ($2 > link) link = $2 } else { if (match($2,",") != 0 ) { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } else { num = split($2,arr,";"); if ( arr[num] > link ) link = arr[num] } } } END{print link}'`
    if ( $noilinks == -1 ) then
      set noiflag = 0
      echo WARNING NOI contains only -1 links
    endif
    # since the last noise may be AFTER the last word...
    @ noilinks --
  endif
  if ( `grep -c '^PRS:' $file` > 0 ) then
    set prsflag = 1
    set prslinks = `cat $file | grep '^PRS:' | awk 'BEGIN{link=-99} { if (match($2,";") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,";"); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $prslinks == -1 ) then
      set prsflag = 0
      echo WARNING PRS contains only -1 links in file $file
    endif
    # since the last boundary may be AFTER the last word...
    @ prslinks --
  endif
  if ( `grep -c '^PRO:' $file` > 0 ) then
    set proflag = 1
    set prolinks = `cat $file | grep '^PRO:' | awk 'BEGIN{link=-99} { if ( match($2,",") == 0 && match($2,";") == 0 ) { if ($2 > link) link = $2 } else { if (match($2,",") != 0 ) { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } else { num = split($2,arr,";"); if ( arr[num] > link ) link = arr[num] } } } END{print link}'`
    if ( $prolinks == -1 ) then
      set proflag = 0
      echo WARNING PRO contains only -1 links
    endif
    # since the boundary may be AFTER the last word...
    @ prolinks --
  endif
  if ( `grep -c '^SYN:' $file` > 0 ) then
    set synflag = 1
    set synlinks = `cat $file | grep '^SYN:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $synlinks == -1 ) then
      set synflag = 0
      echo WARNING SYN contains only -1 links in file $file
    endif
  endif
  if ( `grep -c '^FUN:' $file` > 0 ) then
    set funflag = 1
    set funlinks = `cat $file | grep '^FUN:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $funlinks == -1 ) then
      set funflag = 0
      echo WARNING FUN contains only -1 links in file $file
    endif
  endif
  if ( `grep -c '^LEX:' $file` > 0 ) then
    set lexflag = 1
    set lexlinks = `cat $file | grep '^LEX:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $lexlinks == -1 ) then
      set lexflag = 0
      echo WARNING LEX contains only -1 links in file $file
    endif
  endif
  if ( `grep -c '^POS:' $file` > 0 ) then
    set posflag = 1
    set poslinks = `cat $file | grep '^POS:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $poslinks == -1 ) then
      set posflag = 0
      echo WARNING POS contains only -1 links in file $file
    endif
  endif
  if ( `grep -c '^LMA:' $file` > 0 ) then
    set lmaflag = 1
    set lmalinks = `cat $file | grep '^LMA:' | awk 'BEGIN{link=-99} { if (match($2,",") == 0 ) { if ($2 > link) link = $2 } else { num = split($2,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $lmalinks == -1 ) then
      set lmaflag = 0
      echo WARNING LMA contains only -1 links in file $file
    endif
  endif

  # class 2 tier checks cannot be checked 

  # class 3 tier checks cannot be checked

  # class 4 tier checks
  if ( `grep -c '^SAP:' $file` > 0 ) then
    set sapflag = 1
    set saplinks = `cat $file | grep '^SAP:' | awk 'BEGIN{link=-99} { if (match($4,",") == 0 ) { if ($4 > link) link = $4 } else { num = split($4,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $saplinks == -1 ) then
      set sapflag = 0
      echo WARNING SAP contains only -1 links
    endif
  endif
  if ( `grep -c '^MAU:' $file` > 0 ) then
    set mauflag = 1
    set maulinks = `cat $file | grep '^MAU:' | awk 'BEGIN{link=-99} { if (match($4,",") == 0 ) { if ($4 > link) link = $4 } else { num = split($4,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $maulinks == -1 ) then
      set mauflag = 0
      echo WARNING MAU contains only -1 links
    endif
  endif
  if ( `grep -c '^MAS:' $file` > 0 ) then
    set masflag = 1
    set maslinks = `cat $file | grep '^MAS:' | awk 'BEGIN{link=-99} { if (match($4,",") == 0 ) { if ($4 > link) link = $4 } else { num = split($4,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $maslinks == -1 ) then
      set masflag = 0
      echo WARNING MAS contains only -1 links
    endif
  endif
  if ( `grep -c '^WOR:' $file` > 0 ) then
    set worflag = 1
    set worlinks = `cat $file | grep '^WOR:' | awk 'BEGIN{link=-99} { if ($4 > link) link = $4 } END{print link}'`
    if ( $worlinks == -1 ) then 
      echo WARNING WOR contains only -1 links
      set worflag = 0
    endif
  endif
  if ( `grep -c '^TRN:' $file` > 0 ) then
    set trnflag = 1
    set trnlinks = `cat $file | grep '^TRN:' | awk 'BEGIN{link=-99} { if (match($4,",") == 0 ) { if ($4 > link) link = $4 } else { num = split($4,arr,","); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $trnlinks == -1 ) then
      set trnflag = 0
      echo WARNING TRN contains only -1 links
    endif
  endif
  if ( `grep -c '^USP:' $file` > 0 ) then
    set uspflag = 1
    set usplinks = `cat $file | grep '^USP:' | awk 'BEGIN{link=-99} { if (match($4,";") == 0 ) { if ($4 > link) link = $4 } else { num = split($4,arr,";"); if ( arr[num] > link ) link = arr[num] } } END{print link}'`
    if ( $usplinks == -1 ) then
      set uspflag = 0
      echo WARNING USP contains only -1 links
    endif
  endif


  # class 5 tier checks
  if ( `grep -c '^PRB:' $file` > 0 ) then
    set prbflag = 1
    set prblinks = `cat $file | grep '^PRB:' | awk 'BEGIN{link=-99} { if ($3 > link) link = $3 } END{print link}'`
    if ( $prblinks == -1 ) then
       set prbflag = 0
      echo WARNING PRB contains only -1 links
    endif
  endif

  # evaluation of results
  if ( $trlflag == 1 && $kanlinks != $trllinks ) then
      echo ERROR: TRL $trllinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $tr2flag == 1 && $kanlinks != $tr2links ) then
      echo ERROR: TR2 $tr2links and KAN $kanlinks tier mismatch in $file
  endif
  if ( $trsflag == 1 && $kanlinks != $trslinks ) then
      echo ERROR: TRS $trslinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $trwflag == 1 && $kanlinks != $trwlinks ) then
      echo ERROR: TRW $trwlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $ortflag == 1 && $ortlinks != $kanlinks ) then
      echo ERROR: ORT $ortlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $sapflag == 1 && $saplinks != $kanlinks ) then
      echo ERROR: SAP $saplinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $ptrflag == 1 && $ptrlinks != $kanlinks ) then
      echo ERROR: PTR $ptrlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $mauflag == 1 && $maulinks != $kanlinks ) then
      echo ERROR: MAU $maulinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $masflag == 1 && $maslinks != $kanlinks ) then
      echo ERROR: MAS $maslinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $dasflag == 1 && $daslinks != $kanlinks ) then
      echo ERROR: DAS $daslinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $noiflag == 1 && $noilinks > $kanlinks ) then
      echo ERROR: NOI $noilinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $prbflag == 1 && $prblinks != $kanlinks ) then
      echo ERROR: PRB $prblinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $worflag == 1 && $worlinks != $kanlinks ) then
      echo ERROR: WOR $worlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $prsflag == 1 && $prslinks > $kanlinks ) then
      echo ERROR: PRS $prslinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $proflag == 1 && $prolinks > $kanlinks ) then
      echo ERROR: PRO $prolinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $synflag == 1 && $synlinks > $kanlinks ) then
      echo ERROR: SYN $synlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $funflag == 1 && $funlinks > $kanlinks ) then
      echo ERROR: FUN $funlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $lexflag == 1 && $lexlinks > $kanlinks ) then
      echo ERROR: LEX $lexlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( ( $lexflag == 1 && $funflag != 1 ) || \
       ( $lexflag != 1 && $funflag == 1 ) ) then
      echo ERROR: inconsistency FUN,LEX - one is missing in $file
  endif
  if ( $lexflag == 1 && $funflag == 1 && $lexlinks != $funlinks ) then
      echo ERROR: LEX $lexlinks and FUN $funlinks tier mismatch in $file
  endif
  if ( $posflag == 1 && $poslinks > $kanlinks ) then
      echo ERROR: POS $poslinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $lmaflag == 1 && $lmalinks > $kanlinks ) then
      echo ERROR: LMA $lmalinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $trnflag == 1 && $trnlinks > $kanlinks ) then
      echo ERROR: TRN $trnlinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $uspflag == 1 && $usplinks > $kanlinks ) then
      echo ERROR: USP $usplinks and KAN $kanlinks tier mismatch in $file
  endif
  if ( $tlnflag == 1 && $tlnlinks > $kanlinks ) then
      echo ERROR: TLN $tlnlinks and KAN $kanlinks tier mismatch in $file
  endif
  shift
end
