//***************************************************************************
//
// Headerfile: iotoolbox.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt: routinen zum einlesen und ausgeben von datenfiles
//***************************************************************************
#ifndef IOTOOLBOX
#define IOTOOLBOX

#include "Cverklist.h"
#include "Label.h"

#define MAXLABLEN 15
#define DIRSEP '/'
#define EXTSEP '.'

struct Phondat_Label : Label_base
  {
  Phondat_Label() {lab[0]='\0'; symbol=lab;};
  char lab[MAXLABLEN];
  };
  
struct phondatlabelinf
  {
  phondatlabelinf() {filename=NULL;kano=NULL;ortho=NULL;h=NULL;};
  char* filename;
  char* kano;
  char* ortho;
  char* h;
  
  Cverklist<Phondat_Label*> lablist;
  };

long read_phondat_speechfile(char* name, short** sbufptr);
FILE* open_phondat_speechfile(char* name);
int read_phondat_label_file(char* name,struct phondatlabelinf* plinf);
void swap_short(short* s,int anz);
int write_phondat_label_file(char* name,struct phondatlabelinf* plinf);
int info_from_phondatfilename(char* phdname,char* spkr,char* ortsk,int* num);
int readInventar(char* filename,char*** ppp_inventar);
void fnbody(char* name,char* target);
void lobotomo(char* name,char* path,char* body,char* ext);
#endif
