//***************************************************************************
//
// Headerfile: Chgraph.h
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CHGRAPH
#define CHGRAPH

#include <float.h>
#include "Cgraph.h"
#include "Cheader_io.h"

#define VARGRAPH_ERRNODES -13
#define VARGRAPH_ERREDGES -14
#define INVALID_SYMB -15

#define MAXLINELEN 1000

#define HGRAPH_FILENAMEMARK "##filename="
#define HGRAPH_ENDHEADMARK "##endheader"
#define HGRAPH_ORTHO "##ortho"
#define HGRAPH_ORTHOMASK "1##ortho %1s"

#define HGRAPH_WORDSEP "#&"


class Chgrnode : public Cnode
  {
  public:
  Chgrnode() { rulenumber=-1; symbol = NULL;addata=NULL;wordnum=-1;
  numpath=0;};
  virtual ~Chgrnode() { };
  
  char* symbol;
  char* addata;

  int wordnum;
  int rulenumber;
  double numpath;
  };
  
class Chgredge : public Cedge
  {
  public:
  Chgredge() { log_uewkt=0.0 ; addata=NULL;rulenumber=-1;};
  ~Chgredge() { free(addata); };
  
  int rulenumber;
  char* addata;
  };


//***************************************************************************
// Klassendeklaration: class Chgraph
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Chgraph : public Cgraph, public Cheader_io
  {
  public:

  Chgraph();
  int readHGraph();
  void writeHGraph();
  int readInventar(char* filename);
  virtual Cedge* addEdge(Cedge* ed,Cnode* begn = NULL,Cnode* endn=NULL);
  virtual Cnode* addNode(Cnode* ndptr);
  virtual Cnode* newNode() { return new Chgrnode; };
  virtual Cedge* newEdge() { return new Chgredge; };
  virtual int setNode(Cnode* ndptr,char* key,char* value) ;
  virtual char* putNodeInfo(Cnode* ndptr,char* target) ;
  virtual int setEdge(Cedge* edptr,char* key,char* value) ;
  virtual char* putEdgeInfo(Cedge* edptr,char* target) ;

  virtual void getAddinfo(Cnode* ndptr,char* target);
  virtual void getAddinfo(Cedge* edptr,char* target);

  void removeWordseps();
  void removeSymbols(char** symlist);
  void jumpWordseps(double jumpwk);
  double  scoreEdges();
  void clear();
  ~Chgraph();
  char** inventar;
  
  char* filename;
  Cverklist<char*> ortho;
  int anzinv;
  };


#endif
