
/**************************************************************************
***************************************************************************

Modul           : ioutil.c
Directory       : [sch.sot.seg]
Titel           : input/ output-routinen
Autor           : F. Schiel
Datum/Aenderung : 10.08.90 / 19.11.91


Beschreibung:
enthaelt allgemeine routinen fuer input / output-aktionen, interaktiv
und auf dateien.

Anzulinkende Module	:

Subroutinen:
getwert		: einlesen eines Parameters aus .def-dateien
disp_float2	: darstellung eines 2-dim. float-feldes auf display
disp_short2	: darstellung eines 2-dim short-feldes auf display
disp_int2	: darstellung eines 2-dim int-feldes auf display
iolog		: bedingungsabfrage fuer ausfuehrlichen log in c-modulen
get_string	: get a string from stdin with questioning

*/
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include "ipkclib.h"



/*-------------------------------------------------------------------------

Name            : getwert
Modul           : ioutil.c
Titel           : einlesen eines Parameters aus .def-dateien

Beschreibung:
liest aus datei fdef eine zeile und gibt pointer auf stelle nach
'='-zeichen zurueck. zeilen, die mit '%' beginnen gelten als kommentarzeilen
und werden uebersprungen.

aufruf:    char   *getwert(), buf[135];
           sscanf(getwert(fdef,buf),"%x",variable);			

Parameter:
fdef		: datei deskriptor
buf		: zeile aus datei

Return-Value	: pointer auf char, mit parameter in ascii
*/

char *getwert(FILE *fdef,char buf[100])
{
	char   *mrk;
           
	do {
        	if(!(fgets(buf,100,fdef))){
                	printf("EOF von ...DEF");
                	exit(1);
           	}
	} while (*buf == '%');

        mrk = (char*)strchr(buf,'=') + 1;
        if(mrk == (char*)1) printf("fehler in eingabedatei,kein = gefunden");
        return(mrk);
}

/*-------------------------------------------------------------------------

Name            : disp_float2
Modul           : ioutil.c
Titel           : darstellung eines 2-dim. float-feldes auf display

Beschreibung:
gibt nn zeilen des float-feldes cb auf Display aus 

Parameter:
cb		: 2-dim. floatfeld cb[nn][dim]
nn		: zeilen
dim		: spalten

Return-Value	: void
*/
void disp_float2(float *cb,int nn,int dim)

{
	int i,j,k;

	for(i=0;i<nn;i++)
	{
		printf("Symbol-Nr. %d:\n",i+1);
		for(j=0;j<dim;j++)
		{
			printf("%7.2e  ",*cb);
			cb++;
			if(((j+1)%8) == 0)
				printf("\n");
		}
		printf("\n\n");
	}
}


/*-----------------------------------------------------------------------

Name            : disp_short2
Modul           : ioutil.c
Titel           : darstellung eines 2-dim short-feldes auf display

Beschreibung:
gibt nn zeilen des short-feldes frame auf display aus		

Parameter:
frame		: 2-dim. shortfeld frame[nn][dim]
nn		: zeilen
dim		: spalten

Return-Value	: void
*/
void disp_short2(short *frame,int nn,int dim)

{
	int i,j,k;

	for(i=0;i<nn;i++)
	{
		printf("Frame-Nr. %d:\n",i+1);
		for(j=0;j<dim;j++)
		{
			printf("%d ",*frame);
			frame++;
			if(((j+1)%20) == 0)
				printf("\n");
		}
		printf("\n\n");
	}
}


/*-------------------------------------------------------------------------

Name            : disp_int2
Modul           : ioutil.c
Titel           : darstellung eines 2-dim int-feldes auf display

Beschreibung:
gibt nn zeilen des int-feldes frame auf display aus		

Parameter:
frame		: 2-dim. intfeld frame[nn][dim]
nn		: zeilen
dim		: spalten

Return-Value	: void
*/
void disp_int2(int *frame,int nn,int dim)

{
	int i,j,k;

	for(i=0;i<nn;i++)
	{
		printf("Frame-Nr. %d:\n",i+1);
		for(j=0;j<dim;j++)
		{
			printf("%d ",*frame);
			frame++;
			if(((j+1)%20) == 0)
				printf("\n");
		}
		printf("\n\n");
	}
}

/*----------------------------------------------------------------------

Name		: iolog
Modul		: ioutil
Titel		: bedingung fuer ausfuehrlichen log in c-modulen

Beschreibung:
diese subroutine enthaelt eine statische variable, die mit dem aufruf 
iolog(1) gesetzt und mit iolog(-1) rueckgesetzt werden kann. die abfrage 
der variable erfolgt ueber den return-wert beim aufruf iolog(0), und zwar 
ist 1 = gesetzt und 0 = nicht gesetzt. durch diese abfrage koennen 
ausfuehrliche ausdrucke zu kontrollzwecken in c-modulen aktiviert bzw. 
desaktiviert werden:

	iolog(1);			    aktivierung			
	...
	if(iolog(0)) printf(".......");     ausdruck erfolgt		
	...
	iolog(-1);			    deaktivierung		
	...
	if(iolog(0)) printf(".......");     ausdruck erfolgt nicht	
	...

ist die variable nicht explizit gesetzt oder rueckgesetzt worden, ist die
variable nicht gesetzt (initialisierung, return wert 0).
soll fuer einen bestimmten bereich kein ausdruck erfolgen (z.b. eine 
subroutine, deren ausgaben uninteressant oder zu zahlreich sind), so kann 
die variable mit dem befehl iolog(-2) temporaer deaktiviert werden. mit 
iolog(2) wird eine solche deaktivierung rueckgaengig gemacht. wenn vorher 
aber die variable nicht gesetzt war (iolog(-1) oder initialisierung), 
erfolgt mit iolog(2) keine aktivierung:

	iolog(1);			    aktivierung			
	...
	iolog(-2);			    temporaere deaktivierung
	subroutine();			    subroutine ohne log
	iolog(2);			    aufheben der temporaeren 
	...				    deakktivierung
	...
	if(iolog(0)) printf(".......");     ausdruck erfolgt		
	...
	iolog(-1);			    deaktivierung		
	...
	iolog(-2);			    temporaere deaktivierung
	subroutine();			    subroutine ohne log
	iolog(2);			    aufheben der temporaeren
	...				    akktivierung
	...
	if(iolog(0)) printf(".......");     ausdruck erfolgt nicht	
	...
Solche temporaeren deaktivierungen koennen auch verschachtelt geschehen, 
erst wenn genausoviele male iolog(2) wie vorher iolog(-2) aufgerufen wurden 
wird der return wert wieder 1 (vorausgesetzt vorher wurde durch iolog(1) 
aktiviert). aktivierung durch iolog(1) bewirkt ein ruecksetzen der 
temporaeren deaktivierungen.


Parameter:
log		: 1: variable setzen,  -1: variable ruecksetzen 
		  2: temporaer setzen,  -2: temporaer ruecksetzen 
		  0: abfrage der variable

Return-Value	: 0 nicht gesetzt, 1 gesetzt

----------------------------------------------------------------------*/
int iolog(int log)
{
	static	int	genflag = 0, tmpflag = 0;

    if(log == 1)	{tmpflag = 0; genflag = 1;}
    if(log == -1)	genflag = 0;
    if(log == 2)	tmpflag--;
    if(log == -2)	tmpflag++;

    return(genflag && ! tmpflag);
}

/*----------------------------------------------------------------------
Name            : get_string
Module		: ioutil.c
Title           : get a string from stdin with questioning

Description:
prints questioning text to stdout, reads string from stdin to string,
prints line feed to stdout.

Parameters:
output		: questioning text, no line feed at the end
string		: read string

Return-Value    : void
-------------------------------------------------------------------------*/
void    get_string(char *output,char *string)
{
    printf("%s",output);
    gets(string);
    printf("\n");

    return;
} /* end subroutine : get_string  */
