
/***********************************************************************
************************************************************************

Modul		: statistik
Titel		: routinen zur statistischen auswertung empirischer werte

Autor		: U. Hofmann
Datum/Aenderung : 04.06.91/12.06.91

Beschreibung	: 
enthaelt routinen zur statistischen auswertung ein- bzw. zwei-
dimensionaler, empirischer groessen

Anzulinkende Module (ausser SCHCLIB/LIB):

Enthaltene Funktionen:
staregress		: regressionsgerade berechnen 

*************************************************************************/
# include <ctype.h>
# include <stdio.h>
# include <math.h>
# include "ipkclib.h"
/* # include "vb$dua1:[sch.lib]statistik.h" */

/* DEFINES, die nur innerhalb dieses Moduls Verwendung finden ***********/


/* TYPDEFINITONEN von Typen, die nur innerhalb dieses Moduls vorkommen **/


/* GLOBALE VARIABLEN, dieses Moduls *************************************/


/* FUNKTIONSPROTOTYPEN, die ausserhalb dieses Moduls unbekannt sind *****/


/*----------------------------------------------------------------------

Name            : staregress
Modul		: statistik
Titel		: regressionsgerade berechnen 

Beschreibung:
berechnet zu einer empirisch gewonnenen paar-gruppe (x,y) die optimale
regressionsgerade, unter der voraussetzung linearer korrelation. geraden-
parameter und regressionsfaktor werden berechnet (s. Bronstein Kap. 5.2.4.)

Parameter:
px		: pointer auf vektor mit x-werten, laenge lang 
py		: pointer auf vektor mit y-werten, laenge lang 
laenge		: anzahl der paare (x,y)
r		: pointer auf regressionsfaktor (ergeb.)
b		: pointer auf steigung regressionsgerade (ergeb.)
c		: pointer auf offset regressionsgerade (ergeb.)

Return-Value	: void
----------------------------------------------------------------------*/
void staregress( double *px , double *py , int laenge ,double *r,double *b, 
double *c)
{
    int i;
    double sumx,sumy,xm,ym,quadrx,quadry,varx,vary,varxy,quadrxy,kovar;
    double qsort ( double x);
    sumx = sumy = 0;
    for ( i=0; i < laenge ;i++ )  {
        sumx +=  (*(px + i));
        sumy +=  (*(py + i));
    }
    xm = sumx/laenge ;
    ym = sumy/laenge ;

    quadrx = quadry = quadrxy = 0;
    for ( i=0; i < laenge ;i  ++ )  {
        quadrx += (*(px + i) - xm)*(*(px + i) - xm);
        quadry += (*(py + i) - ym)*(*(py + i) - ym);
        quadrxy += (*(px + i) - xm)*(*(py + i) - ym);
    }
    varx = quadrx /(laenge-1);
    vary = quadry /(laenge-1);
    varxy = varx * vary;
    kovar = quadrxy /(laenge-1);    
    *b = kovar / varx;
    *c = ym - (*b * xm);
    *r = kovar/sqrt(varxy);

 } /* ende subroutine staregress */   
