#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Cfirfilt.h"


Cfirfilt::Cfirfilt(Cvektor* ke)
  {
  koeff=ke;
  order=ke->dim();
  prev = new Cvektor(order);
  if( prev==0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
  count = 0;
  }

void Cfirfilt::ds(double x)
  {
  // nur wert eintragen und nichts berechnen
  prev->setVal(count,x);
  ++count;
  count %= order;
  }

double Cfirfilt::newValue(double x)
  {
  int i;
  register double nv;
  
  prev->setVal(count,x);
  for( i=0 ,nv=0.0 ; i< order ; i++ )
    {
    nv+=prev->getVal((count+order-i)%order)*koeff->getVal(i);
    }
  ++count;
  count %= order;
  return nv;
  }

Cfirfilt::~Cfirfilt()
  {
  delete prev;
  }
