%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Cgraph.h"

extern Cgraph* pgraph;
char linebuf[100];
int bp;

void initbuffer();

int grapherror(char* s) { fprintf(stderr,"%s\n",s); };
extern "C"{
int graphlex(void);
}
%}
%union{
  int intval;
  double doubleval;
  char charval;
  }
%token <intval> INTNUM
%token <charval> CHAR
%token <doubleval> GKZ
%token  WHITE
%token  NODELISTMARK
%token  EDGELISTMARK
%token  L_CB
%token  R_CB
%token  NEWLINE
%start file
%%
/* grammar */
file		: ignore graph ignore
		;
		
graph		: { return EOF; }
                | NODELISTMARK 
                    { 
                    pgraph->clear();
                    } 
                  ignore 
                  L_CB 
                  nodelist 
                  R_CB ignore 
                  EDGELISTMARK 
                  ignore 
                  L_CB 
                  edgelist 
                  R_CB
                    {
                    return 0;
                    }
		| error { yyerror("illegal graph"); }
		;

nodelist	: 
		| nodelist 
		  nodeitem
		
		| error { yyerror("illegal nodelist"); }
		;

nodeitem	: NEWLINE
		
		| INTNUM 
		    {
		    initbuffer(); 
		    }
		  addinfo
		  NEWLINE 
		    {
		    Cnode* ndptr = pgraph->newNode();
		    ndptr->nodenr =  $1 ;
		    if( pgraph->getNodeInfo(ndptr,linebuf) < 0 )
                      {
                        yyerror("error readin Nodeinfo");
                        return 1;
                      }
		    if( pgraph->addNode(ndptr) == NULL )
		      {
		      yyerror("error adding Node");
		      return 1;
		      }
		    }
		                   
		| error { yyerror("illegal nodeitem"); }
		;
edgelist	:
		| edgelist 
		  edgeitem
		  
		| error { yyerror("illegal edgelist"); }
edgeitem	: NEWLINE
		
		| INTNUM 
		  WHITE 
		  INTNUM 
		    { 
		    initbuffer();
		    }
		  addinfo 
		  NEWLINE
		    {
		    Cedge* edptr = pgraph->addEdge(NULL,
		                   pgraph->getNodeNr( $1 ),
		                   pgraph->getNodeNr( $3 ) );
		    if( edptr == NULL )
		      {
		      yyerror("error adding Edge");
		      return 1;
		      }
		    pgraph->getEdgeInfo(edptr,linebuf);
		    }
		    
		| error { yyerror("illegal edgeitem"); }
		;
addinfo		: 
		| addinfo CHAR { sprintf(linebuf + bp++,"%c",$2); }
		| addinfo WHITE { sprintf(linebuf + bp++," "); }
		| addinfo INTNUM { sprintf(linebuf + bp,"%d",$2);
		  for(; linebuf[bp] != '\0' ; bp++) ; }
		| addinfo GKZ { sprintf(linebuf + bp,"%f",$<doubleval>2);
		  for(; linebuf[bp] != '\0' ; bp++) ; }
		| error { yyerror("illegal addinfo"); }
		;
identifier	: CHAR
		| INTNUM
		| identifier INTNUM
		| identifier CHAR
ignore		:
		| ignore NEWLINE
		| ignore WHITE
		;
%%
void initbuffer()
  {
  linebuf[0]='\0';
  bp=0;
  }
  
